% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{confidence_bootstrap}
\alias{confidence_bootstrap}
\alias{confidence_bootstrap-method}
\alias{confidence_bootstrap,numeric-method}
\title{Nonparametric Bootstrap Confidence Interval}
\usage{
confidence_bootstrap(object, ...)

\S4method{confidence_bootstrap}{numeric}(
  object,
  level = 0.95,
  type = c("basic", "normal", "student", "percentiles"),
  t0 = NULL,
  var_t0 = NULL,
  var_t = NULL,
  ...
)
}
\arguments{
\item{object}{A \code{\link{numeric}} vector giving the bootstrap replicates of the
statistic of interest.}

\item{...}{Currently not used.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.
Must be a single number between \eqn{0} and \eqn{1}.}

\item{type}{A \code{\link{character}} string giving the type of confidence
interval to be returned. It must be one "\code{basic}" (the default),
"\code{student}", "\code{normal}" or "\code{percentiles}". Any unambiguous substring can be
given.}

\item{t0}{A length-one \code{\link{numeric}} vector giving the observed value of the
statistic of interest. Must be defined if \code{type} is "\code{basic}", "\code{student}"
or "\code{normal}".}

\item{var_t0}{A length-one \code{\link{numeric}} vector giving an estimate of the
variance of the statistic of interest. Must be defined if \code{type} is
"\code{student}". If \code{var_t0} is undefined and \code{type} is "\code{normal}, it defaults
to \code{var(object)}.}

\item{var_t}{A \code{\link{numeric}} vector giving the variances of the bootstrap
replicates of the variable of interest. Must be defined if \code{type} is
"\code{student}".}
}
\value{
A length-two \code{\link{numeric}} vector giving the lower and upper confidence
limits.
}
\description{
Computes equi-tailed two-sided nonparametric confidence interval.
}
\examples{
x <- rnorm(20)

## Bootstrap
bootstrap(x, do = mean, n = 100)

## Estimate the 25th and 95th percentiles
quant <- function(x) { quantile(x, probs = c(0.25, 0.75)) }
bootstrap(x, n = 100, do = mean, f = quant)

## Get the n bootstrap estimates
(z <- bootstrap(x, n = 100, do = mean, f = function(x) { x }))

## Basic bootstrap confidence interval
confidence_bootstrap(z, level = 0.95, type = "basic", t0 = mean(x))
}
\references{
Davison, A. C. & Hinkley, D. V. (1997). \emph{Bootstrap Methods and Their
Application}. Cambridge Series on Statistical and Probabilistic Mathematics.
Cambridge: Cambridge University Press.
}
\seealso{
\code{\link[=bootstrap]{bootstrap()}}

Other summary statistics: 
\code{\link{confidence_binomial}()},
\code{\link{confidence_mean}()},
\code{\link{confidence_multinomial}()},
\code{\link{interval_credible}()},
\code{\link{interval_hdr}()}
}
\author{
N. Frerebeau
}
\concept{summary statistics}
