% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arlc_generate_clusters.R
\name{arlc_generate_clusters}
\alias{arlc_generate_clusters}
\title{Generate Clusters}
\usage{
arlc_generate_clusters(vec)
}
\arguments{
\item{vec}{A vector of preprocessed rules.}
}
\value{
A list of unique and potential clusters.
}
\description{
This function takes a vector of preprocessed rules, combines elements
starting with the same value, groups segments by the starting value, sorts elements
within each segment, and returns potential clusters.
}
\details{
This function generates potential clusters based on preprocessed rules.
}
\examples{
\donttest{
library(arlclustering)
# Create a sample transactions dataset
sample_gml_file <- system.file("extdata", "karate.gml", package = "arlclustering")
g <- arlc_get_network_dataset(sample_gml_file, "Karate Club")
trans <- arlc_gen_transactions(g$graph)
supportRange <- seq(0.1, 0.2, by = 0.1)
Conf <- 0.5
params <- arlc_get_apriori_thresholds(trans, supportRange, Conf)
grossRules <- arlc_gen_gross_rules(trans, params$minSupp, params$minConf, 1, params$lenRules)
nonRR_rules <- arlc_get_NonR_rules(grossRules$GrossRules)
NonRRSig_rules <- arlc_get_significant_rules(trans, nonRR_rules$FiltredRules)
cleaned_rules <- arlc_clean_final_rules(NonRRSig_rules$FiltredRules)
clusters <- arlc_generate_clusters(cleaned_rules)
}
}
