% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arlc_get_significant_rules.R
\name{arlc_get_significant_rules}
\alias{arlc_get_significant_rules}
\title{Get Significant Rules}
\usage{
arlc_get_significant_rules(all_trans, nonRR_rules)
}
\arguments{
\item{all_trans}{A dataframe containing all transactions.}

\item{nonRR_rules}{A list of non-redundant rules.}
}
\value{
A list containing the total number of significant non-redundant rules and the significant rules themselves.
}
\description{
This function takes all transactions and a set of non-redundant rules as input,
and returns significant rules based on a specified method and adjustment.
}
\details{
This function filters significant rules from a set of non-redundant rules.
}
\examples{
\donttest{
library(arlclustering)
# Create a sample transactions dataset
sample_gml_file <- system.file("extdata", "karate.gml", package = "arlclustering")
g <- arlc_get_network_dataset(sample_gml_file, "Karate Club")
trans <- arlc_gen_transactions(g$graph)
supportRange <- seq(0.1, 0.2, by = 0.1)
Conf <- 0.5
params <- arlc_get_apriori_thresholds(trans, supportRange, Conf)
grossRules <- arlc_gen_gross_rules(trans, params$minSupp, params$minConf, 1, params$lenRules)
nonRR_rules <- arlc_get_NonR_rules(grossRules$GrossRules)
NonRRSig_rules <- arlc_get_significant_rules(trans, nonRR_rules$FiltredRules)
}
}
