% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_sample.R
\name{group_sample}
\alias{group_sample}
\title{Sample Data Frames by a Group Variable}
\usage{
group_sample(
  data,
  group,
  n = 1,
  prop = NULL,
  prob = NULL,
  group_output = FALSE
)
}
\arguments{
\item{data}{A data frame or tibble with at least 1 variable.}

\item{group}{A variable in \code{data} that will be used for groupings.}

\item{n, prop}{Supply either \code{n}, the number of groups, or \code{prop}, the proportion of groups to select. \code{n} must be a positive integer that is greater than or equal to 1. \code{prop} must be a positive numeric value that is greater than 0 and less than or equal to 1.

Default is \code{n} = 1.}

\item{prob}{Optional. A vector of probability weights for obtaining the elements of the group being sampled. Must be the same length as the total unique values in \code{data}'s \code{group} variable.}

\item{group_output}{A logical boolean \code{TRUE} or \code{FALSE}. If \code{TRUE}, returns a grouped tibble.

Default is \code{FALSE}.}
}
\value{
A sampled dataframe
}
\description{
Sample Data Frames by a Group Variable
}
\examples{
vec_coords <- 1:10
df_data <-
 data.frame(
   "x" = vec_coords,
   "y" = vec_coords,
   "group_col" = group_numbers(1:5) |> rep(each = 2)
 )

df_sampled_data_prop <-
 df_data |>
 group_sample(group_col, prop = .2)

df_sampled_data_prop

df_sampled_data_n <-
 df_data |>
 group_sample(group_col, n = 2)

df_sampled_data_n

}
