% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\docType{class}
\name{rules-class}
\alias{rules-class}
\alias{rules}
\alias{initialize,rules-method}
\alias{summary,rules-method}
\alias{summary.rules-class}
\alias{show,summary.rules-method}
\alias{length,rules-method}
\alias{nitems,rules-method}
\alias{labels,rules-method}
\alias{itemLabels,rules-method}
\alias{itemLabels<-,rules-method}
\alias{itemInfo,rules-method}
\alias{lhs}
\alias{lhs,rules-method}
\alias{lhs<-}
\alias{lhs<-,rules-method}
\alias{rhs}
\alias{rhs<-}
\alias{rhs<-,rules-method}
\alias{rhs,rules-method}
\alias{items,rules-method}
\alias{generatingItemsets}
\alias{generatingItemsets,rules-method}
\alias{coercion-rules}
\alias{coerce,rules,data.frame-method}
\title{Class rules --- A Set of Rules}
\usage{
rules(rhs, lhs, itemLabels = NULL, quality = data.frame())

\S4method{summary}{rules}(object, ...)

\S4method{length}{rules}(x)

\S4method{nitems}{rules}(x)

\S4method{labels}{rules}(object, ruleSep = " => ", ...)

\S4method{itemLabels}{rules}(object)

\S4method{itemLabels}{rules}(object) <- value

\S4method{itemInfo}{rules}(object)

lhs(x)

\S4method{lhs}{rules}(x)

lhs(x) <- value

\S4method{lhs}{rules}(x) <- value

rhs(x)

rhs(x) <- value

\S4method{rhs}{rules}(x) <- value

\S4method{rhs}{rules}(x)

\S4method{items}{rules}(x)

generatingItemsets(x)

\S4method{generatingItemsets}{rules}(x)
}
\arguments{
\item{rhs, lhs}{\link{itemMatrix} objects or objects that can be converted using \code{\link[=encode]{encode()}}.}

\item{itemLabels}{a vector of all
possible item labels (character) or a transactions object to copy the item
coding used for \code{encode()} (see \link{itemCoding} for details).}

\item{quality}{a data.frame with quality information (one row per rule).}

\item{object, x}{the object}

\item{...}{further arguments}

\item{ruleSep}{rule separation symbol}

\item{value}{replacement value}
}
\description{
Defines the \code{rules} class to represent a set of association rules and methods to work
with \code{rules}.
}
\details{
Mined rule sets typically contain several interest measures accessible with
the \code{\link[=quality]{quality()}} method. Additional measures can be calculated via
\code{\link[=interestMeasure]{interestMeasure()}}.

To create rules manually, the itemMatrix for the LHS and the RHS of the
rules need to be compatible. See \link{itemCoding} for details.
}
\section{Functions}{
\itemize{
\item \code{summary(rules)}: create a summary

\item \code{length(rules)}: returns the number of rules.

\item \code{nitems(rules)}: returns the number of items used in the current encoding.

\item \code{labels(rules)}: labels for the rules.

\item \code{itemLabels(rules)}: returns item labels for the current encoding.

\item \code{itemLabels(rules) <- value}: change the item labels in the current encoding.

\item \code{itemInfo(rules)}: returns the item info data.frame.

\item \code{lhs(rules)}: returns the LHS of the rules as an \link{itemMatrix}.

\item \code{lhs(rules) <- value}: replaces the LHS of the rules with an \link{itemMatrix}.

\item \code{rhs(rules) <- value}: replaces the RHS of the rules with an \link{itemMatrix}.

\item \code{rhs(rules)}: returns the RHS of the rules as an \link{itemMatrix}.

\item \code{items(rules)}: returns all items in a rule (LHS and RHS) an \link{itemMatrix}.

\item \code{generatingItemsets(rules)}: returns a collection of the itemsets which generated the rules, one itemset for each rule. Note that the collection can be a multiset and contain duplicated elements. Use \code{\link[=unique]{unique()}} to remove duplicates and obtain a proper set. This method produces the same as the result as calling \code{items()}, but wrapped into an \link{itemsets} object with support information.

}}
\section{Slots}{

\describe{
\item{\code{lhs,rhs}}{\link{itemMatrix} representing the left-hand-side and right-hand-side of
the rules.}

\item{\code{quality}}{the quality data.frame}

\item{\code{info}}{a list with mining information.}
}}

\section{Objects from the Class}{

Objects are the result of calling the
function \code{\link[=apriori]{apriori()}}. Objects can also be created by calls of the
form \code{new("rules", ...)}
or by using the constructor function \code{rules()}.
}

\section{Coercions}{

\itemize{
\item \code{as("rules", "data.frame")}
}
}

\examples{
data("Adult")

## Mine rules
rules <- apriori(Adult, parameter = list(support = 0.3))
rules

## Select a subset of rules using partial matching on the items
## in the right-hand-side and a quality measure
rules.sub <- subset(rules, subset = rhs \%pin\% "sex" & lift > 1.3)

## Display the top 3 support rules
inspect(head(rules.sub, n = 3, by = "support"))

## Display the first 3 rules
inspect(rules.sub[1:3])

## Get labels for the first 3 rules
labels(rules.sub[1:3])
labels(rules.sub[1:3],
  itemSep = " + ", setStart = "", setEnd = "",
  ruleSep = " ---> "
)

## Manually create rules using the item coding in Adult and calculate some interest measures
twoRules <- rules(
  lhs = list(
    c("age=Young", "relationship=Unmarried"),
    c("age=Old")
  ),
  rhs = list(
    c("income=small"),
    c("income=large")
  ),
  itemLabels = Adult
)

quality(twoRules) <- interestMeasure(twoRules,
  measure = c("support", "confidence", "lift"), transactions = Adult
)

inspect(twoRules)

}
\seealso{
Superclass: \link{associations}

Other associations functions: 
\code{\link{abbreviate}()},
\code{\link{associations-class}},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{inspect}()},
\code{\link{is.closed}()},
\code{\link{is.generator}()},
\code{\link{is.maximal}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{is.superset}()},
\code{\link{itemsets-class}},
\code{\link{match}()},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{sort}()},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{associations functions}
\keyword{classes}
