% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_asco.R
\name{trace_asco}
\alias{trace_asco}
\title{Simulates the spread of Ascochyta blight in a chickpea field}
\usage{
trace_asco(
  weather,
  paddock_length,
  paddock_width,
  sowing_date,
  harvest_date,
  initial_infection,
  seeding_rate = 40,
  gp_rr = 0.0065,
  max_gp_lim = 5000,
  max_new_gp = 350,
  latent_period_cdd = 150,
  time_zone = "UTC",
  primary_infection_foci = "random",
  primary_inoculum_intensity = 1,
  n_foci = 1,
  spores_per_gp_per_wet_hour = 0.22,
  splash_cauchy_parameter = 0.5,
  wind_cauchy_multiplier = 0.015,
  daily_rain_threshold = 2,
  hourly_rain_threshold = 0.1,
  susceptible_days = 2,
  rainfall_multiplier = FALSE
)
}
\arguments{
\item{weather}{weather data for a representative chickpea paddock for a
complete chickpea growing season for the model's operation.}

\item{paddock_length}{length of a paddock in metres (y).}

\item{paddock_width}{width of a paddock in metres (x).}

\item{sowing_date}{a character string of a date value indicating sowing date
of chickpea seed and the start of the \sQuote{ascotraceR} model. Preferably
in ISO8601 format (YYYY-MM-DD), \emph{e.g.} \dQuote{2020-04-26}. Assumes there
is sufficient soil moisture to induce germination and start the crop
growing season.}

\item{harvest_date}{a character string of a date value indicating harvest
date of chickpea crop, which is also the last day to run the
\sQuote{ascotraceR} model. Preferably in ISO8601 format (YYYY-MM-DD),
\emph{e.g.}, \dQuote{2020-04-26}.}

\item{initial_infection}{a character string of a date value referring to the
initial or primary infection on seedlings, resulting in the production of
infectious growing points.}

\item{seeding_rate}{indicate the rate at which chickpea seed is sown per
square metre. Defaults to \code{40}.}

\item{gp_rr}{refers to rate of increase in chickpea growing points per degree
Celsius per day. Defaults to \code{0.0065}.}

\item{max_gp_lim}{maximum number of chickpea growing points (meristems)
allowed per square metre. Defaults to \code{5000}.}

\item{max_new_gp}{Maximum number of new chickpea growing points (meristems),
which develop per day, per square metre. Defaults to \code{350}.}

\item{latent_period_cdd}{latent period in cumulative degree days (sum of
daily temperature means) is the period between infection and production of
lesions on susceptible growing points. Defaults to \code{150}.}

\item{time_zone}{refers to time in Coordinated Universal Time (UTC).}

\item{primary_infection_foci}{refers to the inoculated coordinates where the
infection starts. Accepted inputs are: \code{centre}/\code{center} or \code{random}
(Default) or a \code{data.frame} with column names \sQuote{x}, \sQuote{y} and
\sQuote{load}. The \code{data.frame} inputs inform the model of specific grid
cell/s coordinates where the epidemic should begin. The \sQuote{load}
column is optional and can specify the \code{primary_inoculum_intensity} for
each coordinate.}

\item{primary_inoculum_intensity}{Refers to the amount of primary infection
as lesions on chickpea plants at the time of \code{initial_infection}. On the
date of initial infection in the experiment. The sources of primary
inoculum can be infected seed, volunteer chickpea plants or infested
stubble from the previous seasons. Defaults to \code{1}.}

\item{n_foci}{Quantifies the number of primary infection foci. The value is
\code{1} when \code{primary_infection_foci = "centre"} and can be greater than \code{1} if
\verb{primary_infection_foci = "random}.}

\item{spores_per_gp_per_wet_hour}{number of spores produced per infectious
growing point during each wet hour. Also known as the \code{spore_rate}. Value
is dependent on the susceptibility of the host genotype.}

\item{splash_cauchy_parameter}{a parameter used in the Cauchy distribution
and describes the median distance spores travel due to rain splashes.
Default to \code{0.5}.}

\item{wind_cauchy_multiplier}{a scaling parameter to estimate a Cauchy
distribution which resembles the possible distances a conidium travels due
to wind driven rain. Defaults to \code{0.015}.}

\item{daily_rain_threshold}{minimum cumulative rainfall required in a day to
allow hourly spore spread events. See also \code{hourly_rain_threshold}.
Defaults to \code{2}.}

\item{hourly_rain_threshold}{minimum rainfall in an hour to trigger a spore
spread event in the same hour (assuming daily_rain_threshold is already
met). Defaults to \code{0.1}.}

\item{susceptible_days}{the number of days for which conidia remain viable on
chickpea after dispersal. Defaults to \code{2}. Conidia remain viable on the
plant for at least 48 hours after a spread event}

\item{rainfall_multiplier}{logical values will turn on or off rainfall
multiplier default method. The default method increases the number of
spores spread per growing point if the rainfall in the spore spread event
hour is greater than one. Numeric values will scale the number of spores
spread per growing point against the volume of rainfall in the hour.
Defaults to \code{FALSE}.}
}
\value{
a nested \code{list} object where each sub-list contains daily data for
the day \code{i_day} (the model's iteration day) generated by the model
including: * \strong{paddock}, an 'x' 'y' \CRANpkg{data.table} containing: *
\strong{x}, location of quadrat on x-axis in paddock, * \strong{y}, location of
quadrat on y-axis in paddock, * \strong{new_gp}, new growing points produced in
the last 24 hours, * \strong{susceptible_gp}, susceptible growing points in the
last 24 hours, * \strong{exposed_gp}, exposed growing points in the last 24
hours, * \strong{infectious_gp}, infectious growing points in the last 24 hours,
\itemize{
\item \strong{i_day}, model iteration day, * \strong{cumulative daily weather data}, a
\CRANpkg{data.table} containing: * \strong{cdd}, cumulative degree days, *
\strong{cwh}, cumulative wet hours, * \strong{cr}, cumulative rainfall in mm, *
\strong{gp_standard}, standard growing points assuming growth is not impeded by
infection, * \strong{infected_coords}, a \CRANpkg{data.table} of only infectious
growing point coordinates, * \strong{new_infections}, a \CRANpkg{data.table} of
newly infected growing points, * \strong{exposed_gps}, a \CRANpkg{data.table} of
exposed growing points in the latent period phase of infection.
}
}
\description{
Simulate the spatiotemporal development of Ascochyta blight in a chickpea
paddock over a growing season. Both host and pathogen activities are
simulated in one square metre cells.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# First weather data needs to be imported and formatted with `format_weather`
Newmarracarra <-
   read.csv(system.file("extdata",
            "1998_Newmarracarra_weather_table.csv", package = "ascotraceR"))
station_data <-
   system.file("extdata", "stat_dat.csv", package = "ascotraceR")

weather_dat <- format_weather(
   x = Newmarracarra,
   POSIXct_time = "Local.Time",
   temp = "mean_daily_temp",
   ws = "ws",
   wd_sd = "wd_sd",
   rain = "rain_mm",
   wd = "wd",
   station = "Location",
   time_zone = "Australia/Perth",
   lonlat_file = station_data)

# Now the `trace_asco` function can be run to simulate disease spread
traced <- trace_asco(
  weather = weather_dat,
  paddock_length = 100,
  paddock_width = 100,
  initial_infection = "1998-06-10",
  sowing_date = "1998-06-09",
  harvest_date = "1998-06-30",
  time_zone = "Australia/Perth",
  gp_rr = 0.0065,
  primary_inoculum_intensity = 40,
  spores_per_gp_per_wet_hour = 0.22,
  primary_infection_foci = "centre")

traced[[23]] # extracts the model output for day 23
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy_trace]{tidy_trace()}}, \code{\link[=summarise_trace]{summarise_trace()}}
}
