% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to.categorical.R
\name{to.categorical}
\alias{to.categorical}
\title{Converts a class vector to a binary class matrix}
\usage{
to.categorical(categorical.vector)
}
\arguments{
\item{categorical.vector}{A factor or character vector representing the class labels.}
}
\value{
A binary class matrix with the number of rows equal to the length of the input vector, and the number of columns equal to the number of unique levels in the input vector. The row and column names of the output matrix are set to the levels of the input vector.
}
\description{
This function converts a class vector to a binary class matrix, with the number of columns equal to the number of levels in the input vector. Each row of the output matrix corresponds to a single observation in the input vector, and the columns represent the different classes in the input vector. A value of 1 in a particular column indicates that the corresponding observation belongs to that class, while a value of 0 indicates that it does not.
}
\examples{
## Generate a class vector
vector.test <- factor(c(1,1,1,2,2,2,3,3,3), levels = c(1,2,3))

## Convert the class vector to binary class matrix
output.matrix <- to.categorical(vector.test)

}
