% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sideinfo_lib.R
\name{ejs}
\alias{ejs}
\title{Extended James-Stein (ejs) estimator}
\usage{
ejs(d, v.d)
}
\arguments{
\item{d}{an n vector of observations}

\item{v.d}{an n vector of variances for each component of d}
}
\value{
est - an n vector holding the estimates
}
\description{
Extended James-Stein estimator of a high dimensional sparse parameter.
}
\details{
Extended James-Stein estimator of mean from Brown (2008) and equation (7.3) in Xie et al. (2012)
}
\examples{
library(asus)
set.seed(42)
d<-rnorm(10,2,1)
v.d<- rep(1,10)
theta.hat<-ejs(d,v.d)

}
\references{
\enumerate{
\item Brown, L.D. (2008). In-Season Prediction of Batting Averages: A Field Test of Empirical
Bayes and Bayes Methodologies. The Annals of Applied Statistics, 2, 113-152
\item Xie, X. C., Kou, S. C., and Brown, L. D. (2012). SURE Estimates for a Heteroscedastic
Hierarchical Model. Journal of the American Statistical Association, 107, 1465-1479.
}
}
\seealso{
\code{\link{sureshrink}},\code{\link{asus}}
}
