% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/lsort.R
\name{lsort}
\alias{lsort}
\title{Sort a data.frame.}
\usage{
lsort(dat, by = 1:dim(dat)[2], asc = rep(TRUE, length(by)),
  na.last = TRUE)
}
\arguments{
\item{dat}{a dataframe or a matrix ("dimnames" are used as the variable names for a matrix)}

\item{by}{a vector or a list of variable names or column indices specifying the "sort by"
variables, the default is to sort by all variables in the order they appear in the data set.}

\item{asc}{a vector with the same length as "by" indicating whether the sorting of each "by"
variable is in ascending order, the default order is ascending.}

\item{na.last}{a flag indicating whether missing values are placed as the last
  elements in the data set, the default is TRUE}
}
\value{
The return value is a sorted dataframe.
}
\description{
A function to sort a data.frame on specific columns.
}
\section{Details}{

The input dataframe is not modified. The code is adapted from code posted to an old s-news
listserve.
}
\examples{
\dontrun{
library(asymLD)
data(snp.freqs)

# sort snp.freqs by "locus1" (ascending) and "allele1" (descending)
newdata <- lsort(snp.freqs, by=c("locus1","allele1"), asc=c(T,F))
head(newdata)
# sort snp.freqs by the fourth and the second variable (ascending)
newdata <- lsort(snp.freqs, by=c(4,2))
# sort "snp.freqs" by "locus1" and the 5th variable (ascending)
newdata <- lsort(snp.freqs, by=list("locus1",5))

}
}

