% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strj-japanese.R
\name{strj-hira-kana}
\alias{strj-hira-kana}
\alias{strj_hiraganize}
\alias{strj_katakanize}
\title{Convert Japanese kana characters}
\usage{
strj_hiraganize(text)

strj_katakanize(text)
}
\arguments{
\item{text}{A character vector containing Japanese text.}
}
\value{
A character vector with kana characters converted to the target script.
}
\description{
Converts Japanese text between hiragana and katakana representations.

These functions transform kana characters while preserving non-kana
characters. The conversion is based on a JavaScript implementation and
handles certain historical or contracted kana forms that are not covered
by standard Unicode transliteration alone.
}
\details{
The conversion behavior is largely compatible with ICU-based
transliteration, with additional support for selected combined or
historical kana characters.
}
\examples{
strj_hiraganize(
  c(
    paste0(
      "\u3042\u306e\u30a4\u30fc\u30cf\u30c8",
      "\u30fc\u30f4\u30a9\u306e\u3059\u304d",
      "\u3068\u304a\u3063\u305f\u98a8"
    ),
    "\u677f\u57a3\u6b7b\u30b9\U0002a708"
  )
)
strj_katakanize(
  c(
    paste0(
      "\u3042\u306e\u30a4\u30fc\u30cf\u30c8",
      "\u30fc\u30f4\u30a9\u306e\u3059\u304d",
      "\u3068\u304a\u3063\u305f\u98a8"
    ),
    "\u672c\u65e5\u309f\u304b\u304d\u6c37\u89e3\u7981"
  )
)
}
