% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_model.R
\name{export_model}
\alias{export_model}
\title{Export Model}
\usage{
export_model(autokeras_model)
}
\arguments{
\item{autokeras_model}{: A trained AutokerasModel instance.}
}
\value{
keras.Model instance. The best model found during the search, loaded
  with trained weights.
}
\description{
Export the best trained Keras Model.\cr
Actually, exporting the model as a Keras model is not working as expected,
check out the bug https://github.com/keras-team/autokeras/issues/929 .
}
\examples{
\dontrun{
library("keras")

# use the MNIST dataset as an example
mnist <- dataset_mnist()
c(x_train, y_train) \%<-\% mnist$train
c(x_test, y_test) \%<-\% mnist$test

library("autokeras")

# Initialize the image classifier
clf <- model_image_classifier(max_trials = 10) \%>\% # It tries 10 different models
  fit(x_train, y_train) # Feed the image classifier with training data

# Predict with the best model
(predicted_y <- clf \%>\% predict(x_test))

# Evaluate the best model with testing data
clf \%>\% evaluate(x_test, y_test)

# Get the best trained Keras model, to work with the keras R library
export_model(clf)
}

}
