% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_describe_task_sets}
\alias{ecs_describe_task_sets}
\title{Describe Task Sets}
\usage{
ecs_describe_task_sets(
  cluster = NULL,
  service = NULL,
  taskSets = NULL,
  include = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{cluster}{Character. The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service that the...}

\item{service}{Character. The short name or full Amazon Resource Name (ARN) of the service that the task sets exist in.}

\item{taskSets}{List. The ID or full Amazon Resource Name (ARN) of task sets to describe.}

\item{include}{List. Specifies whether to see the resource tags for the task set.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Describes the task sets in the specified cluster
and service. This is used when a service uses the \code{EXTERNAL} deployment
controller type. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-services.html}{Amazon ECS Deployment Types}
in the \emph{Amazon Elastic Container Service Developer
Guide}.
}
\section{cluster}{

The
short name or full Amazon Resource Name (ARN) of the cluster that hosts
the service that the task sets exist in.
}

\section{service}{

The short
name or full Amazon Resource Name (ARN) of the service that the task
sets exist in.
}

\section{taskSets}{

The ID or full Amazon Resource Name
(ARN) of task sets to describe.
}

\section{include}{

Specifies whether to
see the resource tags for the task set. If \code{TAGS} is specified, the tags
are included in the response. If this field is omitted, tags are not
included in the response.
}

