% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdgraph.R
\name{tdgraph}
\alias{tdgraph}
\title{Create Time-Dissolution Graphs}
\usage{
tdgraph(
  data_file,
  output_plot_file,
  output_csv_file,
  label_y1 = 0.055,
  label_y2 = 0.032,
  param,
  value,
  eq.label,
  rr.label,
  .
)
}
\arguments{
\item{data_file}{Path to the data CSV file.}

\item{output_plot_file}{Path to save the graph as a TIFF file.}

\item{output_csv_file}{Path to save the CSV file.}

\item{label_y1}{Y-coordinate for the first equation label.}

\item{label_y2}{Y-coordinate for the second equation label.}

\item{param}{Placeholder for param variable.}

\item{value}{Placeholder for value variable.}

\item{eq.label}{Placeholder for eq.label variable.}

\item{rr.label}{Placeholder for rr.label variable.}

\item{.}{Placeholder for . variable.}
}
\value{
A data frame with the equation of the line, R-squared value, and y-intercept for each parameter.
}
\description{
Create Time-Dissolution Graphs
}
\examples{


data_file <- system.file("extdata", "mydata.csv", package = "bSi")
output_plot_file <- file.path(tempdir(), "plot1.tiff")
output_csv_file <- file.path(tempdir(), "output.csv")
param <- NULL
value <- NULL
eq.label <- NULL
rr.label <- NULL
. <- NULL
tdgraph(data_file, output_plot_file, output_csv_file,
        label_y1 = 0.055, label_y2 = 0.032, param, value, eq.label, rr.label, .)


}
