% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictODX.R
\name{predictODX}
\alias{predictODX}
\alias{plot.baclava.ODX.pred}
\title{Estimate the Overall and Per Screen Overdiagnosis Rates}
\usage{
predictODX(
  object,
  screening.schedule,
  other.cause.rates,
  groups.rateP = NULL,
  screen.type = NULL,
  burnin = 1000L,
  verbose = TRUE
)

\method{plot}{baclava.ODX.pred}(x, y, ...)
}
\arguments{
\item{object}{An object of S3 class 'baclava'. The value object returned
by \code{fit_baclava()}.}

\item{screening.schedule}{A numeric vector object. A vector of ages at
which screenings occur.}

\item{other.cause.rates}{A data.frame object. Must contain columns "Rate"
and "Age".}

\item{groups.rateP}{An integer scalar object. If model included groups with
different sojourn parameters, the group for which overdiagnosis is to
be estimated. Must be one of \code{object$setup$groups.rateP}}

\item{screen.type}{An integer scalar object. If model included screen-type,
specific sensitivity parameters, the screen-type for which
overdiagnosis is to be estimated. Must be one of \code{object$setup$groups.beta}}

\item{burnin}{An integer object. Optional. The number of burn-in samples.
Used only for \code{type = "trace"}. One trace plot is generated for
the burnin iterations; a second for the post-burnin iterations. Note, this
refers to the kept (thinned) samples.}

\item{verbose}{A logical object. If TRUE, progress bars will be displayed.}

\item{x}{A an object of S3 class 'baclava.PDX.pred' as returned by \code{predictODX()}.}

\item{y}{Ignored.}

\item{...}{Ignored.}
}
\value{
A list object. For each screen in \code{screening.schedule},
  a matrix providing the mean total overdiagnosis and the mean overdiagnosis
  due to indolent/progressive tumors, as well as their 95% prediction intervals.
  Similarly, element \code{overall} provides these estimates for the full
  screening schedule.
}
\description{
Using the posterior parameter distributions, calculates the infinite
  population estimates of the probability of overdiagnosis at 
  each screening episode due to indolence and/or death by other causes.
}
\details{
Provided birth cohort life table is an all cause tables obtained from the 
  CDC Life Tables. Vital Statistics of the United States, 1974 Life Tables, 
  Vol. II, Section 5. 1976. Estimated "other cause" mortality will thus be 
  overestimated when using these tables. It is recommended that user provide 
  data that has been corrected to exclude death due to the disease under analysis.
}
\section{Functions}{
\itemize{
\item \code{plot(baclava.ODX.pred)}: Generate column plot of predicted overdiagnosis for each screen.

}}
\examples{

data(screen_data)

theta_0 <- list("rate_H" = 7e-4, "shape_H" = 2.0,
                "rate_P" = 0.5  , "shape_P" = 1.0,
                "beta" = 0.9, psi = 0.4)
prior <- list("rate_H" = 0.01, "shape_H" = 1,
              "rate_P" = 0.01, "shape_P" = 1,
              "a_psi" = 1/2 , "b_psi" = 1/2,
              "a_beta" = 38.5, "b_beta" = 5.8)

# This is for illustration only -- the number of MCMC samples should be
# significantly larger and the epsilon values should be tuned.
example <- fit_baclava(data.assess = data.screen,
                       data.clinical = data.clinical,
                       t0 = 30.0,
                       theta_0 = theta_0,
                       prior = prior)
                       
# if rates are not available, an all cause dataset is provided in the package
# NOTE: these predictions will be over-estimated
           
data(all_cause_rates)
all_cause_rates <- all_cause_rates[, c("Age", "both")]
colnames(all_cause_rates) <- c("Age", "Rate")

# using single screen for example speed
predicted_odx <- predictODX(object = example, 
                            other.cause.rates = all_cause_rates,
                            screening.schedule = 40, 
                            burnin = 10)

plot(predicted_odx)

}
