% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8.barrel_ord_summary.R
\name{barrel_ord_summary}
\alias{barrel_ord_summary}
\title{Summary Statistics for Ordination Objects}
\usage{
barrel_ord_summary(ord)
}
\arguments{
\item{ord}{An ordination object of class \code{rda}, \code{cca}, \code{capscale}, \code{dbrda}, or \code{metaMDS}.}
}
\value{
A named list with components:
\describe{
\item{method}{Class of the ordination object as a character string.}
\item{R2_adj}{Adjusted R-squared (percentage) for constrained ordinations; \code{NA} for NMDS.}
\item{axis_var}{Named numeric vector of variance explained by each axis (percentage), if available.}
\item{stress}{Stress value for NMDS objects.}
\item{message}{Message explaining output, especially for NMDS or missing R2.}
}
}
\description{
Computes adjusted R-squared and percentage of variance explained for constrained ordination methods
(e.g., \code{rda}, \code{cca}, \code{capscale}, \code{dbrda}), or returns the stress value for
non-metric multidimensional scaling (\code{metaMDS}).
}
\examples{
library(vegan)
data(dune)
data(dune.env)

# PCA (unconstrained ordination)
pca <- rda(dune)
barrel_ord_summary(pca)

# RDA (constrained ordination)
rda_mod <- rda(dune ~ A1 + Moisture, data = dune.env)
barrel_ord_summary(rda_mod)

# NMDS
nmds <- metaMDS(dune, k = 2)
barrel_ord_summary(nmds)

# dbRDA
dbrda_mod <- dbrda(dune ~ A1 + Management, data = dune.env, distance = "bray")
barrel_ord_summary(dbrda_mod)

}
