% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-phenips-clim.R
\encoding{UTF-8}
\name{model.phenips_clim.customize}
\alias{model.phenips_clim.customize}
\title{Customize PHENIPS-Clim}
\arguments{
\item{dd_onset_start_date}{The date, when the degree days start to sum up ('MM-DD').}

\item{dd_onset_base}{Base temperature to calculate degree days to trigger the onset.}

\item{onset_func}{Function with the SpatRasters \code{tmax} (maximum temperature)
and \code{dd_tmax} (degree days of maximum temperature) as parameters.
The function should return \code{TRUE} when the base onset is
triggered. See \code{onset_add_dd} for the actual onset of infestation.}

\item{dd_onset_alt_start_date, dd_onset_alt_base, onset_alt_func}{Alternative
way to calculate the diapause (see \code{dd_onset_start_date}, \code{dd_onset_base} and
\code{onset_func}). The first of both onset variants will be used. Set
\code{onset_alt_func = NULL} to disable the alternative onset calculation.}

\item{onset_add_dd}{Vector of options to calculate the actual onset of
infestation. The vector should be named after the share of beetles that
already started breeding when the onset is triggered (choose an option via
\verb{phenology(..., onset_mode = [option])} when applying the
model). The values specify the degree days that are required starting at the
first positive return value of \code{onset_func}.}

\item{tfly}{Minimum temperature that beetles need to fly.}

\item{dd_total_dev}{Degree days that are required for a generation to fully
develop}

\item{dev_oviposition}{Named numeric vector of shares in the total development
when the oviposition is finished. The vector should be named after the share
of beetles that should be taken into account (choose an option via
\verb{phenology(..., oviposition_mode = [option])} when applying the
model).}

\item{dev_end}{Share in total development when the juvenile beetle's
development ends. Usable if the development above this threshold should
account for mating, oviposition etc.}

\item{dev_sister_brood}{Share in the total development, when a sister brood
will be established.}

\item{dev_mortal_min, dev_mortal_max}{The beetles are considered to be in
white stages (egg, larva, pupa) if their development exceeds \code{dev_mortal_min}
and subceeds \code{dev_mortal_max}. During these stages, the beetles could die
due to a mortality event. \code{NULL} means that no lower/upper threshold is
defined.}

\item{topt}{Temperature for optimal development.}

\item{func_btmean, func_btmax, func_btdiff}{Functions to calculate the
bark temperatures (see \insertCite{Baier2007;nobrackets}{barrks},
equations A.3 to A.5). Each parameter will be passed as SpatRaster:
\itemize{
\item \code{tmean}: mean air temperature
\item \code{tmax}: maximum air temperature
\item \code{rad}: radiation
\item \code{btmax}: maximum bark temperature
}}

\item{dev_rates}{Data frame that specifies the development rates per day depending
on the mean temperature and the temperature amplitude. Column names are the
mean temperatures and row names the temperature amplitudes both with one
decimal place.
base onset (see \code{onset_func}) to trigger the actual onset.}

\item{model_end_date}{Date when the model ends (no further development will
be modeled).}

\item{first_diapause_date}{Date before which an initiation of the diapause is
impossible ('MM-DD').}

\item{diapause_thermal_func}{Function to calculate the initiation
of the diapause if the model was applied using \code{phenology(..., diapause_mode = 'thermal')}.
The diapause will be initiated the last time when the function returns \code{TRUE}.}

\item{daylength_dia}{When the daylength falls below this threshold, diapause
will be initiated if the model was applied using
\code{phenology(..., diapause_mode = 'photoperiodic')}.}

\item{tlethal}{Temperature threshold below which white stages will die.}
}
\description{
In \code{barrks}, \code{\link[=model]{model()}} is used to customize a model. Here, the parameters are
described that can be used to customize PHENIPS-Clim. The model
is currently unpublished. This manual will be updated as soon as a
publication is available. Look \link[=model.phenips_clim.customize]{here} to find
out how to apply the model.
}
\details{
In \code{barrks}, \code{\link[=model]{model()}} is used to customize a model. The following code
illustrates which parameters are available for PHENIPS-Clim and specifies their
default values.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{model("phenips-clim",

      # ==== onset ====

      dd_onset_start_date = '03-01',
      dd_onset_base = 12,
      onset_func = \\(tmax, dd_tmax) \{
        0.564071 * tmax + 0.006434 * dd_tmax - 12.37046 > 0
      \},

      dd_onset_alt_start_date = '04-01',
      dd_onset_alt_base = 8.3,
      onset_alt_func = \\(tmax, dd_tmax) dd_tmax >= 140,

      onset_add_dd = c('0.1' = 0, '0.5' = 90, '0.9' = 190),

      # ==== development ====

      tfly = 16.5,

      dd_total_dev = 557,

      dev_oviposition = c('0.1' = 0.1,
                          '0.5' = 0.15,
                          '0.9' = 0.26),
      dev_end = 1,
      dev_sister_brood = 0.3,

      dev_mortal_min = 0,
      dev_mortal_max = 0.6,

      topt = 30.4,

      func_btmean = function(tmean, rad) \{
        -0.173 + 0.0008518 * rad + 1.054 * tmean
      \},
      func_btmax = function(tmax, rad) \{
        1.656 + 0.002955 * rad + 0.534 * tmax + 0.01884 * tmax ^ 2
      \},
      func_btdiff = function(tmax) \{
        (-310.667 + 9.603 * tmax) / 24
      \},

      # dev_rates too large to show here, type `params('phenips-clim')$dev_rates`
      # to get the dev_rates that are used by default
      # dev_rates = matrix(...),

      model_end_date = '12-31',

      # ==== diapause ====

      first_diapause_date = '08-12',
      diapause_thermal_func = function(daylength, tmax) \{
        0.8619156 * daylength + 0.5081128 * tmax - 23.63691 > 0
      \},
      daylength_dia = 14.5,

      # ==== mortality ====

      tlethal = -5
)
}\if{html}{\out{</div>}}
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=model]{model()}}, \code{\link[=phenology]{phenology()}}, \code{\link{model.phenips_clim.apply}}

Other model customizations: 
\code{\link{model.bso.customize}},
\code{\link{model.chapy.customize}},
\code{\link{model.joensson.customize}},
\code{\link{model.lange.customize}},
\code{\link{model.phenips.customize}},
\code{\link{model.rity.customize}}
}
\concept{model customizations}
