% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_run_expectancy_code.R
\name{run_expectancy_code}
\alias{run_expectancy_code}
\title{\strong{Generate run expectancy and related measures from Baseball Savant data}}
\usage{
run_expectancy_code(df, level = "plate appearance")
}
\arguments{
\item{df}{A data frame generated from Baseball Savant.}

\item{level}{Whether you want run expectancy calculated at the plate appearance or pitch level. Defaults to plate appearance.}
}
\value{
Returns a tibble with the following columns:\tabular{ll}{
   col_name \tab types \cr
   pitch_type \tab character \cr
   game_date \tab Date \cr
   release_speed \tab numeric \cr
   release_pos_x \tab numeric \cr
   release_pos_z \tab numeric \cr
   player_name \tab character \cr
   batter \tab numeric \cr
   pitcher \tab numeric \cr
   events \tab character \cr
   description \tab character \cr
   spin_dir \tab logical \cr
   spin_rate_deprecated \tab logical \cr
   break_angle_deprecated \tab logical \cr
   break_length_deprecated \tab logical \cr
   zone \tab numeric \cr
   des \tab character \cr
   game_type \tab character \cr
   stand \tab character \cr
   p_throws \tab character \cr
   home_team \tab character \cr
   away_team \tab character \cr
   type \tab character \cr
   hit_location \tab integer \cr
   bb_type \tab character \cr
   balls \tab integer \cr
   strikes \tab integer \cr
   game_year \tab integer \cr
   pfx_x \tab numeric \cr
   pfx_z \tab numeric \cr
   plate_x \tab numeric \cr
   plate_z \tab numeric \cr
   on_3b \tab numeric \cr
   on_2b \tab numeric \cr
   on_1b \tab numeric \cr
   outs_when_up \tab integer \cr
   inning \tab numeric \cr
   inning_topbot \tab character \cr
   hc_x \tab numeric \cr
   hc_y \tab numeric \cr
   tfs_deprecated \tab logical \cr
   tfs_zulu_deprecated \tab logical \cr
   fielder_2 \tab numeric \cr
   umpire \tab logical \cr
   sv_id \tab character \cr
   vx0 \tab numeric \cr
   vy0 \tab numeric \cr
   vz0 \tab numeric \cr
   ax \tab numeric \cr
   ay \tab numeric \cr
   az \tab numeric \cr
   sz_top \tab numeric \cr
   sz_bot \tab numeric \cr
   hit_distance_sc \tab numeric \cr
   launch_speed \tab numeric \cr
   launch_angle \tab numeric \cr
   effective_speed \tab numeric \cr
   release_spin_rate \tab numeric \cr
   release_extension \tab numeric \cr
   game_pk \tab numeric \cr
   pitcher_1 \tab numeric \cr
   fielder_2_1 \tab numeric \cr
   fielder_3 \tab numeric \cr
   fielder_4 \tab numeric \cr
   fielder_5 \tab numeric \cr
   fielder_6 \tab numeric \cr
   fielder_7 \tab numeric \cr
   fielder_8 \tab numeric \cr
   fielder_9 \tab numeric \cr
   release_pos_y \tab numeric \cr
   estimated_ba_using_speedangle \tab numeric \cr
   estimated_woba_using_speedangle \tab numeric \cr
   woba_value \tab numeric \cr
   woba_denom \tab integer \cr
   babip_value \tab integer \cr
   iso_value \tab integer \cr
   launch_speed_angle \tab integer \cr
   at_bat_number \tab numeric \cr
   pitch_number \tab numeric \cr
   pitch_name \tab character \cr
   home_score \tab numeric \cr
   away_score \tab numeric \cr
   bat_score \tab numeric \cr
   fld_score \tab numeric \cr
   post_away_score \tab numeric \cr
   post_home_score \tab numeric \cr
   post_bat_score \tab numeric \cr
   post_fld_score \tab numeric \cr
   if_fielding_alignment \tab character \cr
   of_fielding_alignment \tab character \cr
   spin_axis \tab numeric \cr
   delta_home_win_exp \tab numeric \cr
   delta_run_exp \tab numeric \cr
   final_pitch_game \tab numeric \cr
   final_pitch_at_bat \tab numeric \cr
   runs_scored_on_pitch \tab numeric \cr
   bat_score_after \tab numeric \cr
   final_pitch_inning \tab numeric \cr
   bat_score_start_inning \tab numeric \cr
   bat_score_end_inning \tab numeric \cr
   cum_runs_in_inning \tab numeric \cr
   runs_to_end_inning \tab numeric \cr
   count_base_out_state \tab character \cr
   avg_re \tab numeric \cr
   next_count_base_out_state \tab character \cr
   next_avg_re \tab numeric \cr
   change_re \tab numeric \cr
   re24 \tab numeric \cr
}
}
\description{
These functions allow a user to generate run expectancy and related measures and variables from Baseball Savant data. Measures and variables will be added to the data frame.
}
\examples{
\donttest{
 try({
   df <- statcast_search(start_date = "2016-04-06", end_date = "2016-04-15", 
                         playerid = 621043, player_type = 'batter') 
   run_expectancy_code(df, level = "plate appearances")
 })
}
}
