% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_statcast_search.R
\name{statcast_search}
\alias{statcast_search}
\alias{statcast_search.default}
\alias{statcast_search_batters}
\alias{statcast_search_pitchers}
\title{\strong{Query Statcast by Date Range and Players}}
\usage{
statcast_search(
  start_date = Sys.Date() - 1,
  end_date = Sys.Date(),
  playerid = NULL,
  player_type = "batter",
  ...
)

statcast_search.default(
  start_date = Sys.Date() - 1,
  end_date = Sys.Date(),
  playerid = NULL,
  player_type = "batter",
  ...
)

statcast_search_batters(start_date, end_date, batterid = NULL, ...)

statcast_search_pitchers(start_date, end_date, pitcherid = NULL, ...)
}
\arguments{
\item{start_date}{Date of first game for which you want data.
Format must be in YYYY-MM-DD format.}

\item{end_date}{Date of last game for which you want data.
Format must be in YYYY-MM-DD format.}

\item{playerid}{The MLBAM ID for the player whose data you want to query.}

\item{player_type}{The player type. Can be \code{batter} or \code{pitcher}.
Default is \code{batter}}

\item{...}{currently ignored}

\item{batterid}{The MLBAM ID for the batter whose data you want to query.}

\item{pitcherid}{The MLBAM ID for the pitcher whose data you want to query.}
}
\value{
Returns a tibble with Statcast data with the following columns:\tabular{ll}{
   col_name \tab types \cr
   pitch_type \tab character \cr
   game_date \tab Date \cr
   release_speed \tab numeric \cr
   release_pos_x \tab numeric \cr
   release_pos_z \tab numeric \cr
   player_name \tab character \cr
   batter \tab numeric \cr
   pitcher \tab numeric \cr
   events \tab character \cr
   description \tab character \cr
   spin_dir \tab logical \cr
   spin_rate_deprecated \tab logical \cr
   break_angle_deprecated \tab logical \cr
   break_length_deprecated \tab logical \cr
   zone \tab numeric \cr
   des \tab character \cr
   game_type \tab character \cr
   stand \tab character \cr
   p_throws \tab character \cr
   home_team \tab character \cr
   away_team \tab character \cr
   type \tab character \cr
   hit_location \tab integer \cr
   bb_type \tab character \cr
   balls \tab integer \cr
   strikes \tab integer \cr
   game_year \tab integer \cr
   pfx_x \tab numeric \cr
   pfx_z \tab numeric \cr
   plate_x \tab numeric \cr
   plate_z \tab numeric \cr
   on_3b \tab numeric \cr
   on_2b \tab numeric \cr
   on_1b \tab numeric \cr
   outs_when_up \tab integer \cr
   inning \tab numeric \cr
   inning_topbot \tab character \cr
   hc_x \tab numeric \cr
   hc_y \tab numeric \cr
   tfs_deprecated \tab logical \cr
   tfs_zulu_deprecated \tab logical \cr
   fielder_2 \tab numeric \cr
   umpire \tab logical \cr
   sv_id \tab character \cr
   vx0 \tab numeric \cr
   vy0 \tab numeric \cr
   vz0 \tab numeric \cr
   ax \tab numeric \cr
   ay \tab numeric \cr
   az \tab numeric \cr
   sz_top \tab numeric \cr
   sz_bot \tab numeric \cr
   hit_distance_sc \tab numeric \cr
   launch_speed \tab numeric \cr
   launch_angle \tab numeric \cr
   effective_speed \tab numeric \cr
   release_spin_rate \tab numeric \cr
   release_extension \tab numeric \cr
   game_pk \tab numeric \cr
   pitcher_1 \tab numeric \cr
   fielder_2_1 \tab numeric \cr
   fielder_3 \tab numeric \cr
   fielder_4 \tab numeric \cr
   fielder_5 \tab numeric \cr
   fielder_6 \tab numeric \cr
   fielder_7 \tab numeric \cr
   fielder_8 \tab numeric \cr
   fielder_9 \tab numeric \cr
   release_pos_y \tab numeric \cr
   estimated_ba_using_speedangle \tab numeric \cr
   estimated_woba_using_speedangle \tab numeric \cr
   woba_value \tab numeric \cr
   woba_denom \tab integer \cr
   babip_value \tab integer \cr
   iso_value \tab integer \cr
   launch_speed_angle \tab integer \cr
   at_bat_number \tab numeric \cr
   pitch_number \tab numeric \cr
   pitch_name \tab character \cr
   home_score \tab numeric \cr
   away_score \tab numeric \cr
   bat_score \tab numeric \cr
   fld_score \tab numeric \cr
   post_away_score \tab numeric \cr
   post_home_score \tab numeric \cr
   post_bat_score \tab numeric \cr
   post_fld_score \tab numeric \cr
   if_fielding_alignment \tab character \cr
   of_fielding_alignment \tab character \cr
   spin_axis \tab numeric \cr
   delta_home_win_exp \tab numeric \cr
   delta_run_exp \tab numeric \cr
}

Returns a tibble with Statcast data.

Returns a tibble with Statcast data with the following columns:\tabular{ll}{
   col_name \tab types \cr
   pitch_type \tab character \cr
   game_date \tab Date \cr
   release_speed \tab numeric \cr
   release_pos_x \tab numeric \cr
   release_pos_z \tab numeric \cr
   player_name \tab character \cr
   batter \tab numeric \cr
   pitcher \tab numeric \cr
   events \tab character \cr
   description \tab character \cr
   spin_dir \tab logical \cr
   spin_rate_deprecated \tab logical \cr
   break_angle_deprecated \tab logical \cr
   break_length_deprecated \tab logical \cr
   zone \tab numeric \cr
   des \tab character \cr
   game_type \tab character \cr
   stand \tab character \cr
   p_throws \tab character \cr
   home_team \tab character \cr
   away_team \tab character \cr
   type \tab character \cr
   hit_location \tab integer \cr
   bb_type \tab character \cr
   balls \tab integer \cr
   strikes \tab integer \cr
   game_year \tab integer \cr
   pfx_x \tab numeric \cr
   pfx_z \tab numeric \cr
   plate_x \tab numeric \cr
   plate_z \tab numeric \cr
   on_3b \tab numeric \cr
   on_2b \tab numeric \cr
   on_1b \tab numeric \cr
   outs_when_up \tab integer \cr
   inning \tab numeric \cr
   inning_topbot \tab character \cr
   hc_x \tab numeric \cr
   hc_y \tab numeric \cr
   tfs_deprecated \tab logical \cr
   tfs_zulu_deprecated \tab logical \cr
   fielder_2 \tab numeric \cr
   umpire \tab logical \cr
   sv_id \tab character \cr
   vx0 \tab numeric \cr
   vy0 \tab numeric \cr
   vz0 \tab numeric \cr
   ax \tab numeric \cr
   ay \tab numeric \cr
   az \tab numeric \cr
   sz_top \tab numeric \cr
   sz_bot \tab numeric \cr
   hit_distance_sc \tab numeric \cr
   launch_speed \tab numeric \cr
   launch_angle \tab numeric \cr
   effective_speed \tab numeric \cr
   release_spin_rate \tab numeric \cr
   release_extension \tab numeric \cr
   game_pk \tab numeric \cr
   pitcher_1 \tab numeric \cr
   fielder_2_1 \tab numeric \cr
   fielder_3 \tab numeric \cr
   fielder_4 \tab numeric \cr
   fielder_5 \tab numeric \cr
   fielder_6 \tab numeric \cr
   fielder_7 \tab numeric \cr
   fielder_8 \tab numeric \cr
   fielder_9 \tab numeric \cr
   release_pos_y \tab numeric \cr
   estimated_ba_using_speedangle \tab numeric \cr
   estimated_woba_using_speedangle \tab numeric \cr
   woba_value \tab numeric \cr
   woba_denom \tab integer \cr
   babip_value \tab integer \cr
   iso_value \tab integer \cr
   launch_speed_angle \tab integer \cr
   at_bat_number \tab numeric \cr
   pitch_number \tab numeric \cr
   pitch_name \tab character \cr
   home_score \tab numeric \cr
   away_score \tab numeric \cr
   bat_score \tab numeric \cr
   fld_score \tab numeric \cr
   post_away_score \tab numeric \cr
   post_home_score \tab numeric \cr
   post_bat_score \tab numeric \cr
   post_fld_score \tab numeric \cr
   if_fielding_alignment \tab character \cr
   of_fielding_alignment \tab character \cr
   spin_axis \tab numeric \cr
   delta_home_win_exp \tab numeric \cr
   delta_run_exp \tab numeric \cr
}

Returns a tibble with Statcast data with the following columns:\tabular{ll}{
   col_name \tab types \cr
   pitch_type \tab character \cr
   game_date \tab Date \cr
   release_speed \tab numeric \cr
   release_pos_x \tab numeric \cr
   release_pos_z \tab numeric \cr
   player_name \tab character \cr
   batter \tab numeric \cr
   pitcher \tab numeric \cr
   events \tab character \cr
   description \tab character \cr
   spin_dir \tab logical \cr
   spin_rate_deprecated \tab logical \cr
   break_angle_deprecated \tab logical \cr
   break_length_deprecated \tab logical \cr
   zone \tab numeric \cr
   des \tab character \cr
   game_type \tab character \cr
   stand \tab character \cr
   p_throws \tab character \cr
   home_team \tab character \cr
   away_team \tab character \cr
   type \tab character \cr
   hit_location \tab integer \cr
   bb_type \tab character \cr
   balls \tab integer \cr
   strikes \tab integer \cr
   game_year \tab integer \cr
   pfx_x \tab numeric \cr
   pfx_z \tab numeric \cr
   plate_x \tab numeric \cr
   plate_z \tab numeric \cr
   on_3b \tab numeric \cr
   on_2b \tab numeric \cr
   on_1b \tab numeric \cr
   outs_when_up \tab integer \cr
   inning \tab numeric \cr
   inning_topbot \tab character \cr
   hc_x \tab numeric \cr
   hc_y \tab numeric \cr
   tfs_deprecated \tab logical \cr
   tfs_zulu_deprecated \tab logical \cr
   fielder_2 \tab numeric \cr
   umpire \tab logical \cr
   sv_id \tab character \cr
   vx0 \tab numeric \cr
   vy0 \tab numeric \cr
   vz0 \tab numeric \cr
   ax \tab numeric \cr
   ay \tab numeric \cr
   az \tab numeric \cr
   sz_top \tab numeric \cr
   sz_bot \tab numeric \cr
   hit_distance_sc \tab numeric \cr
   launch_speed \tab numeric \cr
   launch_angle \tab numeric \cr
   effective_speed \tab numeric \cr
   release_spin_rate \tab numeric \cr
   release_extension \tab numeric \cr
   game_pk \tab numeric \cr
   pitcher_1 \tab numeric \cr
   fielder_2_1 \tab numeric \cr
   fielder_3 \tab numeric \cr
   fielder_4 \tab numeric \cr
   fielder_5 \tab numeric \cr
   fielder_6 \tab numeric \cr
   fielder_7 \tab numeric \cr
   fielder_8 \tab numeric \cr
   fielder_9 \tab numeric \cr
   release_pos_y \tab numeric \cr
   estimated_ba_using_speedangle \tab numeric \cr
   estimated_woba_using_speedangle \tab numeric \cr
   woba_value \tab numeric \cr
   woba_denom \tab integer \cr
   babip_value \tab integer \cr
   iso_value \tab integer \cr
   launch_speed_angle \tab integer \cr
   at_bat_number \tab numeric \cr
   pitch_number \tab numeric \cr
   pitch_name \tab character \cr
   home_score \tab numeric \cr
   away_score \tab numeric \cr
   bat_score \tab numeric \cr
   fld_score \tab numeric \cr
   post_away_score \tab numeric \cr
   post_home_score \tab numeric \cr
   post_bat_score \tab numeric \cr
   post_fld_score \tab numeric \cr
   if_fielding_alignment \tab character \cr
   of_fielding_alignment \tab character \cr
   spin_axis \tab numeric \cr
   delta_home_win_exp \tab numeric \cr
   delta_run_exp \tab numeric \cr
}
}
\description{
This function allows you to query Statcast data as provided on \url{https://baseballsavant.mlb.com}
}
\examples{
\donttest{
  ### Harper
  try(statcast_search(start_date = "2022-10-06", 
                      end_date = "2022-10-16", 
                      playerid = 547180, 
                      player_type = 'batter'))
  ### Framber
  try(statcast_search(start_date = "2022-10-06", 
                      end_date = "2022-10-16", 
                      playerid = 664285, 
                      player_type = 'pitcher'))
  ### Daily
  try(statcast_search(start_date = "2022-11-04", 
                      end_date = "2022-11-06"))
}
\donttest{
  try({
    correa <- statcast_search_batters(start_date = "2016-04-06",
      end_date = "2016-04-15", batterid = 621043)
    daily <- statcast_search_batters(start_date = "2016-04-06",
      end_date = "2016-04-06", batterid = NULL)
  })
}
\donttest{
  try({
    x <- statcast_search_pitchers(start_date = "2016-04-06",
      end_date = "2016-04-15", pitcherid = 592789)
    daily <- statcast_search_pitchers(start_date = "2016-04-06",
      end_date = "2016-04-06", pitcherid = NULL)
  })
}
}
