% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.sf}
\alias{plot.sf}
\title{Plot simple features simply}
\usage{
\method{plot}{sf}(x, ...)
}
\arguments{
\item{x}{sf object (the data.frame one)}

\item{...}{arguments passed to [sf::plot_sfc]}
}
\value{
used for its side effects of creating a plot
}
\description{
Overrides `sf::plot.sf` and wraps the call to `plot(st_geometry(x))`. When
working with spatial data it's often useful to create maps where we
overlay spatially coincident data in a plot.
}
\details{
This is used so that plots aren't always facetted by all attributes, coloured
by them, or leaving the plot unusable for subsequent additional drawing. The
key feature is that we don't have to change our behaviour and good habits
depending on the format in use.
}
\examples{
x <- read_sf(system.file("shape/nc.shp", package="sf"))
## all we've changed is the plot command
plot(x)
## we can overplot without format-specific acrobatics
plot(x[sample(1:nrow(x), 10), ], col = rainbow(10), add = TRUE)
abline(v = 34); axis(2)
}
