% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hillModel.R
\name{evalHillModel}
\alias{evalHillModel}
\title{Evaluate a Hill dose response model}
\usage{
evalHillModel(conc, hpar)
}
\arguments{
\item{conc}{A vector of concentrations (including 0 or Inf)}

\item{hpar}{A four parameter vector specifying the Hill model. The values of
the parameter vector are, in order, the dose of median effect (also often
referred to as the EC50), the Hill slope, the minimal effect (observed when
no drug or dose is present), and the maximal effect (theoretically observed
when the drug or dose is infinite).}
}
\value{
A vector of response values the same length as \code{conc}
}
\description{
Evaluate a Hill dose response model
}
\examples{
conc <- c(0,2^(-6:3),Inf)
hpar <- c(1,3,0,100)

response <- evalHillModel(conc, hpar)
}
