% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toer.R
\name{toer}
\alias{toer}
\alias{toer,OneStageBasket-method}
\alias{toer,TwoStageBasket-method}
\title{Type 1 Error Rate}
\usage{
toer(design, ...)

\S4method{toer}{OneStageBasket}(
  design,
  p1 = NULL,
  n,
  lambda,
  weight_fun,
  weight_params = list(),
  globalweight_fun = NULL,
  globalweight_params = list(),
  results = c("fwer", "group"),
  ...
)

\S4method{toer}{TwoStageBasket}(
  design,
  p1 = NULL,
  n,
  n1,
  lambda,
  interim_fun,
  interim_params = list(),
  weight_fun,
  weight_params = list(),
  globalweight_fun = NULL,
  globalweight_params = list(),
  results = c("fwer", "group"),
  ...
)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupOneStageBasket} or \code{setupTwoStageBasket}.}

\item{...}{Further arguments.}

\item{p1}{Probabilities under the alternative hypothesis. If
\code{length(p1) ==  1}, then this is a common probability for all
baskets. If \code{is.null(p1)} then the type 1 error rate under the
global null hypothesis is computed.}

\item{n}{The sample size per basket.}

\item{lambda}{The posterior probability threshold. See details for more
information.}

\item{weight_fun}{Which function should be used to calculate the pairwise
weights.}

\item{weight_params}{A list of tuning parameters specific to
\code{weight_fun}.}

\item{globalweight_fun}{Which function should be used to calculate the
global weights.}

\item{globalweight_params}{A list of tuning parameters specific to
\code{globalweight_fun}.}

\item{results}{Whether only the family wise error rate (option \code{fwer})
or also the rejection probabilities per group (option \code{group}) should
be returned.}

\item{n1}{The sample size per basket for the interim analysis in case of a
two-stage design.}

\item{interim_fun}{Which type of interim analysis should be conducted
in case of a two-stage design.}

\item{interim_params}{A list of tuning parameters specific to
\code{interim_fun}.}
}
\value{
If \code{results = "fwer"} then the family wise type 1 error rate is
returned as a numeric value. If \code{results = "group"} then a list with
the rejection probabilities per group and the family wise type 1 error rate
is returned. If all p1 > p0 then the family wise type 1 error rate
is calculated under the global null hypothesis. For baskets with p1 =
p0 the rejection probabilities corresponds to the type 1 error rate, for
baskets with p1 > p0 the rejection probabilities corresponds to the
power.
}
\description{
Computes the exact family wise type 1 error rate of a basket trial .
}
\details{
\code{toer} computes the exact family wise type 1 error rate and the
exact rejection probabilities per group. The family wise type 1 error rate
is the probability to reject at least one null hypothesis for a basket with
p1 = p0. If all p1 > p0 then the family wise type 1 error
rate under the global null hypothesis is computed. The rejection
probabilities correspond to the type 1 error rate for baskets with p1 =
p0 and to the power for baskets with p1 > p0.
}
\section{Methods (by class)}{
\itemize{
\item \code{toer(OneStageBasket)}: Type 1 error rate for a single-stage basket design.

\item \code{toer(TwoStageBasket)}: Type 1 error rate for two-stage basket design.

}}
\examples{
design <- setupOneStageBasket(k = 3, p0 = 0.2)
toer(design, n = 15, lambda = 0.99, weight_fun = weights_fujikawa)
}
