% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_lambda.R
\name{adjust_lambda.bhm}
\alias{adjust_lambda.bhm}
\title{Adjust Lambda for the BHM Design}
\usage{
\method{adjust_lambda}{bhm}(
  design,
  n,
  p1 = NULL,
  alpha = 0.05,
  design_params = list(),
  iter = 1000,
  n_mcmc = 10000,
  prec_digits = 3,
  data = NULL,
  ...
)
}
\arguments{
\item{design}{An object created with one of the \code{setup} functions.}

\item{n}{The sample sizes of the baskets. A vector must be used for varying sample sizes.}

\item{p1}{Probabilities used for the simulation. If \code{NULL}
then all probabilities are set to p0.}

\item{alpha}{The one-sided significance level.}

\item{design_params}{A list of params that is specific to the class of
\code{design}.}

\item{iter}{The number of iterations in the simulation. Is ignored if
\code{data} is specified.}

\item{n_mcmc}{Number of MCMC samples.}

\item{prec_digits}{Number of decimal places that are considered when
adjusting lambda.}

\item{data}{A data matrix with k column with the number of responses for each
basket. Has to be generated with \code{get_data}. If \code{data} is used,
then \code{iter} is ignored.}

\item{...}{Further arguments.}
}
\value{
A list containing the greatest estimated value for \code{lambda} with
\code{prec_digits} decimal places which controls the family wise error rate
at level \code{alpha} (one-sided) and the estimated family wise error rate
for the estimated \code{lambda}.
}
\description{
Adjust Lambda for the BHM Design
}
\examples{
design <- setup_bhm(k = 3, p0 = 0.2, p_target = 0.5)
\donttest{
# Equal sample sizes
adjust_lambda(design = design, n = 15, design_params = list(tau_scale = 1),
  iter = 100, n_mcmc = 5000)

# Unequal sample sizes
adjust_lambda(design = design, n = c(15, 20, 25),
  design_params = list(tau_scale = 1),
  iter = 100, n_mcmc = 5000)
}
}
