% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoms.R
\name{geom_borrow.fujikawa}
\alias{geom_borrow.fujikawa}
\title{Plot a Fujikawa basket trial's posterior distribution after borrowing}
\usage{
\method{geom_borrow}{fujikawa}(design, n, r, epsilon, tau, logbase, ...)
}
\arguments{
\item{design}{An object created with one of the \code{setup} functions.}

\item{n}{The sample sizes of the baskets. A vector must be used for varying sample sizes.}

\item{r}{Vector of responses.}

\item{epsilon}{Tuning parameter that determines the amount of borrowing.
See \code{\link{setup_fujikawa}}).}

\item{tau}{Tuning parameter that determines how similar the baskets
have to be that information is shared. See \code{\link{setup_fujikawa}}).}

\item{logbase}{Tuning parameter. The base of the logarithm that is used to
calculate the Jensen-Shannon divergence.}

\item{...}{Further arguments to be passed to `geom_function`.}
}
\value{
A list of ggplot layers of type `geom_function`.
}
\description{
Plot a Fujikawa basket trial's posterior distribution after borrowing
}
\examples{
# Example for a basket trial with Fujikawa's Design
design <- setup_fujikawa(k = 3, p0 = 0.2)
n <- 20
r <- c(4, 5, 2)
epsilon <- 2
tau <- 0.5
# One facet per basket
library(ggplot2)
ggplot() +
    geom_borrow(design, n, r, epsilon, tau, logbase = exp(1)) +
    facet_wrap(vars(basket))
# Colour different baskets
ggplot() +
    geom_borrow(design, n, r, epsilon, tau,
                logbase = exp(1), aes(colour = basket))
}
