% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_results.R
\name{get_results.cpplim}
\alias{get_results.cpplim}
\title{Get Results for Simulation of a Basket Trial with a Limited Calibrated Power
Prior Design}
\usage{
\method{get_results}{cpplim}(
  design,
  n,
  p1 = NULL,
  lambda,
  tune_a,
  tune_b,
  iter = 1000,
  data = NULL,
  ...
)
}
\arguments{
\item{design}{An object of class \code{cpplim}.}

\item{n}{The sample sizes of the baskets. A vector must be used for varying sample sizes.}

\item{p1}{Probabilities used for the simulation. If \code{NULL}
then all probabilities are set to p0.}

\item{lambda}{The posterior probability threshold.}

\item{tune_a}{First tuning parameter that determines the amount of borrowing
based on pairwise similarity between baskets.}

\item{tune_b}{Second tuning parameter that determines the amount of borrowing
based on pairwise similarity between baskets.}

\item{iter}{The number of iterations in the simulation. Is ignored if
\code{data} is specified.}

\item{data}{A data matrix with k column with the number of responses for each
basket. Has to be generated with \code{get_data}. If \code{data} is used,
then \code{iter} is ignored.}

\item{...}{Further arguments.}
}
\value{
A matrix of results with \code{iter} rows. A 0 means, that the
null hypothesis that the response probability exceeds \code{p0} was not
rejected, a 1 means, that the null hypothesis was rejected.
}
\description{
Get Results for Simulation of a Basket Trial with a Limited Calibrated Power
Prior Design
}
\examples{
design <- setup_cpplim(k = 3, p0 = 0.2)

# Equal sample sizes
get_results(design = design, n = 20, p1 = c(0.2, 0.5, 0.5),
  lambda = 0.95, tune_a = 1, tune_b = 1, iter = 100)

# Unequal sample sizes
get_results(design = design, n = c(15, 20, 25), p1 = c(0.2, 0.5, 0.5),
  lambda = 0.95, tune_a = 1, tune_b = 1, iter = 100)
}
