% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{setup_app}
\alias{setup_app}
\title{Setup Adaptive Power Prior Design Object}
\usage{
setup_app(k, p0, shape1 = 1, shape2 = 1)
}
\arguments{
\item{k}{The number of baskets.}

\item{p0}{A common probability under the null hypothesis.}

\item{shape1}{First common shape parameter of the beta prior.}

\item{shape2}{Second common shape parameter of the beta prior.}
}
\value{
An S3 object of class \code{app}
}
\description{
Setup Adaptive Power Prior Design Object
}
\details{
The class \code{app} implements the adaptive power prior design for
sequential clinical trials proposed by Ollier et al. (2020).
}
\examples{
design_app <- setup_app(k = 3, p0 = 0.2)
}
\references{
Ollier, A., Morita, S., Ursino, M., & Zohar, S. (2020). An
adaptive power prior for sequential clinical trials - Application to bridging
studies. Statistical methods in medical research, 29(8), 2282–2294.
}
