% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal.bayesian.R
\name{cal.bayesian}
\alias{cal.bayesian}
\title{Bayesian regressions to calibrate the clumped isotopes paleothermometer using
\code{stan}.}
\usage{
cal.bayesian(
  calibrationData,
  numSavedSteps = 3000,
  priors = "Informative",
  MC = TRUE
)
}
\arguments{
\item{calibrationData}{The target calibration dataset.}

\item{numSavedSteps}{Number of MCMC iterations to save.}

\item{priors}{Either \code{Informative}, \code{Weak}, or
\code{Uninformative} on the slope and intercept.}

\item{MC}{Multicore (TRUE/FALSE)}
}
\value{
A list the raw models fit in \code{stan} and a multi-model
        comparison based on \code{loo}.
}
\description{
Bayesian regressions to calibrate the clumped isotopes paleothermometer using
\code{stan}.
}
