% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/automated_ppc.R
\name{automated_ppc}
\alias{automated_ppc}
\title{Automated Posterior Predictive Checks}
\usage{
automated_ppc(model, observed_data, n_samples = 1000, p_value_threshold = 0.05)
}
\arguments{
\item{model}{A fitted brmsfit object.}

\item{observed_data}{Numeric vector of observed data.}

\item{n_samples}{Integer. Number of posterior draws to use (default: 1000).}

\item{p_value_threshold}{Numeric. Threshold for flagging extreme p-values (default: 0.05).}
}
\value{
A list of class \code{automated_ppc} containing diagnostics and flags.
}
\description{
Automatically computes a suite of posterior predictive checks to diagnose
model fit. It compares observed data against posterior predictive samples
across multiple statistics (mean, sd, min, max, skewness, kurtosis).
}
