% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic_report.R
\name{diagnostic_report}
\alias{diagnostic_report}
\title{Diagnostic Report for Bayesian Models}
\usage{
diagnostic_report(
  model,
  output_file = NULL,
  output_format = "pdf",
  include_sections = c("model_summary", "convergence", "posterior_summary",
    "recommendations"),
  rhat_threshold = 1.01,
  ess_threshold = 0.1,
  open_report = TRUE
)
}
\arguments{
\item{model}{A fitted model object (brmsfit, stanfit, etc.)}

\item{output_file}{Character. Path for output file}

\item{output_format}{Character. Format: "pdf", "html", "docx"}

\item{include_sections}{Character vector. Sections to include}

\item{rhat_threshold}{Numeric. R-hat threshold for flagging (default: 1.01)}

\item{ess_threshold}{Numeric. Effective sample size ratio threshold}

\item{open_report}{Logical. Open report after generation?}
}
\value{
Invisibly returns output file path
}
\description{
Generates comprehensive diagnostics and creates a formatted report
for fitted Bayesian models (brmsfit, stanfit, etc.)
}
