% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effective_sample_size_diagnostics.R
\name{effective_sample_size_diagnostics}
\alias{effective_sample_size_diagnostics}
\alias{print.ess_diagnostics}
\alias{plot.ess_diagnostics}
\title{Effective Sample Size Diagnostics}
\usage{
effective_sample_size_diagnostics(
  model,
  parameters = NULL,
  min_ess = 400,
  tail_quantiles = c(0.025, 0.975),
  by_chain = TRUE,
  plot = TRUE,
  ...
)

\method{print}{ess_diagnostics}(x, ...)

\method{plot}{ess_diagnostics}(x, ...)
}
\arguments{
\item{model}{A fitted Bayesian model (brmsfit, stanfit, or compatible)}

\item{parameters}{Character vector of parameter names to analyze (default: all)}

\item{min_ess}{Numeric. Minimum acceptable ESS (default: 400)}

\item{tail_quantiles}{Numeric vector. Quantiles for tail ESS (default: c(0.025, 0.975))}

\item{by_chain}{Logical. Whether to compute ESS per chain (default: TRUE)}

\item{plot}{Logical. Whether to generate diagnostic plots (default: TRUE)}

\item{...}{Additional arguments passed to plotting functions}

\item{x}{Object of class \code{ess_diagnostics} (for print/plot methods).}
}
\value{
An object of class \code{ess_diagnostics} containing:
\item{ess_summary}{Summary statistics for ESS across parameters}
\item{bulk_ess}{Bulk ESS for each parameter}
\item{tail_ess}{Tail ESS for each parameter}
\item{by_chain_ess}{Per-chain ESS if \code{by_chain = TRUE}}
\item{problematic_params}{Parameters with ESS below threshold}
\item{recommendations}{Specific recommendations for improving ESS}
}
\description{
Comprehensive diagnostics for effective sample size (ESS) in MCMC chains,
including bulk ESS, tail ESS, and per-chain analysis.
}
\details{
Effective Sample Size (ESS) measures the number of independent samples
in MCMC chains after accounting for autocorrelation. This function provides:

\itemize{
\item \strong{Bulk ESS}: ESS for central posterior mass (mean, median)
\item \strong{Tail ESS}: ESS for extreme quantiles (credible intervals)
\item \strong{Per-chain ESS}: Identifies which chains have low ESS
}

Low ESS indicates high autocorrelation and may require:
\itemize{
\item Longer chains (more iterations)
\item Better parameterization
\item Stronger priors
\item Different sampler settings
}
}
\examples{
\donttest{
library(brms)
fit <- brm(mpg ~ hp + wt, data = mtcars)

# Comprehensive ESS diagnostics
ess_diag <- effective_sample_size_diagnostics(
  model = fit,
  min_ess = 400,
  by_chain = TRUE
)

print(ess_diag)
plot(ess_diag)
}

}
