% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_label.R
\name{bayes_label}
\alias{bayes_label}
\title{Label probability images to create categorical maps}
\usage{
bayes_label(x)
}
\arguments{
\item{x}{SpatRaster object with probabilities images}
}
\value{
A SpatRaster object
}
\description{
Takes a classified image with probabilities, and
labels the image with the pixel of higher probability
}
\examples{
if (bayes_run_examples()) {
    # select a file with probability values
    data_dir <- system.file("/extdata/probs/", package = "bayesEO")
    file <- list.files(data_dir)
    # create a SpatRaster object from the file
    probs_file <- paste0(data_dir, "/", file)
    # provide the labels
    labels <- c("Water", "ClearCut_Burn", "ClearCut_Soil",
             "ClearCut_Veg", "Forest", "Wetland")
    # read the probs file
    probs <- bayes_read_probs(probs_file, labels)
    # produce a labelled map
    map <- bayes_label(probs)
    # plot the labelled map
    bayes_plot_map(map)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
