% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubmedQuery.R
\name{pubmedQuery}
\alias{pubmedQuery}
\title{Perform PubMed queries on 2x2 combinations of term vectors.}
\usage{
pubmedQuery(rowTerms, colTerms, sleepTime = 0.01)
}
\arguments{
\item{rowTerms}{Character vector of terms that should make up the rows of the resulting mention count data frame.}

\item{colTerms}{Character vector of terms for the columns.}

\item{sleepTime}{How much time (in seconds) to sleep between successive PubMed queries. If you set this too low, PubMed may shut down your connection to prevent overloading their servers.}
}
\value{
A data frame of the number of mentions for each combination of terms.
}
\description{
Perform PubMed queries on the intersections of two character vectors. This function is a wrapper to RISmed::EUtilsSummary with type = 'esearch', db = 'pubmed'.
}

