% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/fecrt.model.R
\name{fecrt.model}
\alias{FECRT.model}
\alias{fecrt.model}
\title{Create an MCMC model to analyse FECRT Data}
\usage{
fecrt.model(data, paired.model = FALSE, fix.controls = FALSE,
  fix.efficacy = TRUE, fix.variation = TRUE, zero.inflation = FALSE,
  effect.prior = "dbeta(1,1)", mean.prior = "dmouch(1)",
  precision.prior = "dmouch(1)", ...)
}
\arguments{
\item{data}{a data frame containing the dataset to be analysed in long format, with columns of Count (the number of eggs observed), Subject (a name or number uniquely identifiyig each animal/patient) and Time (1 = Pre-treatment, 2 = Post-treatment), and optional columns of Sample (a number) and Control (1 = Treatment group, 2 = Control group).  Multiple Counts are permitted from the same subject, either with the same Sample number (repeated count observations from the same processed laboratory sample) or different Sample numbers (independently analysed samples from the same individual).}

\item{paired.model}{the FECRT can be run using two compound gamma distributions to describe the variability within and between animals in place of the single gamma distribution combining the two sources of variability.  When using two compound gamma distributions for pre-treatment data, the post-treatment data are paired to the pre-treatment data by animal.  The advantage of using a single distribution is that the model is more identifiable, and therefore is likely to converge more quickly and return errors less frequently.  The advantage of the paired model is that it allows repeat measurements tobe incorporated in the model, and non-randomly missing data (ie.protocols that involve post-treatment sampling of only animals with a high pre-treatment count) to be modelled appropriately.  The simple model cannot be used when using repeat samples within animal, and will provide inaccurate results if animals are targeted for post-treatment sampling based on their pre-treatment count.  Default uses the simple model (FALSE).}

\item{fix.controls}{the FECRT can be run either using control animals to estimate the overall reduction atrributable to the treatment, or assuming that the true mean of the controls does not change over time and only using this data to improve the estimate of the pre-treatment mean.  The former is more in the spirit of what is intended with controls, but the latter will give smaller confidence intervals at the cost of the strong assumption that the underlying population mean has not changed between the treatment dates.  Default FALSE.}

\item{fix.efficacy}{force all treatment animals to have the same reduction following treatment, so that all residual variation is absorbed by the extra-Poisson sampling variation. Setting this to FALSE requires the paired model and a substantial number of replicate samples within subjects.  Default TRUE.}

\item{fix.variation}{force the post-treatment extra-Poisson variation to be the same as that pre-treatment.  This parameter is difficult to estimate, so forcing it to be the same as the pre-treatment value may improve convergence, although it is a strong assumption.  Note that this parameter and the efficacy variance parameter are likely to be strongly inter-dependent.  Default FALSE.}

\item{zero.inflation}{option to use a zero-inflated gamma Poisson inplace of the gamma Poisson distribution.  If TRUE, zero inflated distributions are used pre- and post-treatment (with the prevalence fixed between pre- and post-treatment distributions).  Default FALSE.}

\item{effect.prior}{the prior distribution to use for the change in mean egg count.  Any syntactically valid distribution in JAGS may be used, but it must include the default initial values of 0.01 and 1. Default is a uniform distribution between 0 and 1.}

\item{mean.prior}{the prior distribution to use for the pre-treatment mean egg count.  Any syntactically valid strictly positive distribution in JAGS may be used, but it must include the default initial value of the arithmetic mean pre-treatment count. Default is DuMouchel's prior distribution.}

\item{precision.prior}{the prior distribution to use for the shape parameter (k) of the various gamma distributions used.  Any syntactically valid strictly positive distribution in JAGS may be used, but it must include the default initial values of 0.1 and 10. Default is DuMouchel's prior distribution.}

\item{...}{other options to be passed directly to \code{\link[runjags]{autorun.jags}} when setting up the model.  This may include initial values, for example .RNG.seed and .RNG.name to allow the analysis to be reproducible.}
}
\value{
Returns an object of class \code{\link[runjags]{runjags-class}}
}
\description{
This function generates and compiles a JAGS model representation of a faecal egg count reduction test (FECRT) analysis.  The return value can be updated manually using \code{\link[runjags]{extend.jags}}
}
\details{
Pre-treatment data are assumed to arise from either a gamma-Poisson or zero-inflated gamma-Poisson distribution, with post-treatment data described by a separate gamma-Poisson or zero-inflated gamma-Poisson distribution.  The change in mean between these distributions is therefore the mean egg count reduction.  A change in shape parameter of the gamma distribution is also permitted if fix.variation=FALSE. If paired.model=TRUE, a slightly different formulation is used whereby the observed count pre-treatment is assumed to follow a compound gamma-gamma-Poisson distribution with the variability within and between animals separated.  The post treatment mean for each animal is derived from the pre-treatment animal mean and FEC reduction.  This formulation allows data with non-random missing post-treatment counts to be analysed correctly, and also allows data with repeat counts from an individual to be analysed - providing a method of increasing the power of the method substantially.  The fix.efficacy=FALSE option is only permitted for the paired.model=TRUE option, and allows the reduction estimated to vary between individuals.  Problems with convergence are likely to be encountered with this option unless there is a substantial amount of replicate data avaialble within individuals.
}
\examples{
\dontrun{
# Data in an appropriate format:
data <- data.frame(Count=rpois(80,rep(c(10,10,2,2), 20)),
Subject=rep(1:20, each=4), Time=rep(rep(1:2,each=2),40),
Sample=1:2, Control=rep(c(0,1), each=40))
# Compile the model - a paired model is required because
# there are replicate samples within an individual:
model <- fecrt.model(data, paired.model=TRUE)
# Update the model - requires runjags:
library('runjags')
results <- extend.jags(model, burnin=5000)
}
}
\references{
M. J. Denwood, S. W. J. Reid, S. Love, M. K. Nielsen, L. Matthews, I. J. McKendrick, and G. T. Innocent. Comparison of three alternative methods for analysis of equine Faecal Egg Count Reduction Test data. Prev. Vet. Med. (2009), doi:10.1016/j.prevetmed.2009.11.009
}
\seealso{
\code{\link{fecrt.analysis}} for comparisons of fitted MCMC models to bootstrapping results
}
\keyword{models}

