% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ets.R
\name{Holt}
\alias{Holt}
\title{A constructor for a Holt trend state-space model.}
\usage{
Holt(ts, damped = FALSE, xreg = NULL, genT = FALSE, series.name = NULL)
}
\arguments{
\item{ts}{a numeric or ts object with the univariate time series.}

\item{damped}{a boolean value to specify a damped trend local level model. By
default, \code{damped = FALSE}. If \code{trend} option is \code{FALSE} then
\code{damped = FALSE} automatically.}

\item{xreg}{Optionally, a numerical matrix of external regressors,
which must have the same number of rows as ts. It should not be a data frame.}

\item{genT}{a boolean value to specify for a generalized t-student SSM model.}

\item{series.name}{an optional string vector with the time series names.}
}
\value{
The function returns a list with the data for running \code{stan()} f
unction of \pkg{rstan} package.
}
\description{
Constructor of the \code{ets("A","A","Z")} object for Bayesian estimation in \pkg{Stan}.
}
\details{
The \code{genT = TRUE} option generates a t-student innovations SSM model. For
more references check Ardia (2010); or Fonseca, et. al (2019).

The default priors used in a \code{ssm( )} model are:

\itemize{
\item{level ~ normal(0,0.5)}
\item{trend ~ normal(0,0.5)}
\item{damped~ normal(0,0.5)}
\item{sigma0 ~ t-student(0,1,7)}
\item{level1 ~ normal(0,1)}
\item{trend1 ~ normal(0,1)}
\item{dfv ~ gamma(2,0.1)}
\item{breg ~ t-student(0,2.5,6)}
}

For changing the default prior use the function \code{set_prior()}.
}
\examples{
mod1 = Holt(ipc)

# Declaring a Holt damped trend model for the ipc data.
mod2 = Holt(ipc,damped = TRUE)

}
\references{
Fonseca, T. and Cequeira, V. and Migon, H. and Torres, C. (2019). The effects of
degrees of freedom estimation in the Asymmetric GARCH model with Student-t
Innovations. \emph{arXiv} \code{doi: arXiv: 1910.01398}.
}
\seealso{
\code{Sarima}, \code{auto.arima}, \code{set_prior}, and \code{garch}.
}
\author{
Asael Alonzo Matamoros.
}
