% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_models.R
\name{stan_naive}
\alias{stan_naive}
\title{Naive and Random Walk models.}
\usage{
stan_naive(
  ts,
  seasonal = FALSE,
  m = 0,
  chains = 4,
  iter = 2000,
  warmup = floor(iter/2),
  adapt.delta = 0.9,
  tree.depth = 10,
  prior_mu0 = NULL,
  prior_sigma0 = NULL,
  series.name = NULL,
  ...
)
}
\arguments{
\item{ts}{a numeric or ts object with the univariate time series.}

\item{seasonal}{a Boolean value for select a seasonal random walk instead.}

\item{m}{an optional integer value for the seasonal period.}

\item{chains}{an integer of the number of Markov Chains chains to be run. By
default, \code{chains = 4}.}

\item{iter}{an integer of total iterations per chain including the warm-up. By
default, \code{iter = 2000}.}

\item{warmup}{a positive integer specifying number of warm-up (aka burn-in)
iterations. This also specifies the number of iterations used for step-size
adaptation, so warm-up samples should not be used for inference. The number
of warm-up iteration should not be larger than \code{iter}.By default,
\code{warmup = iter/2}.}

\item{adapt.delta}{an optional real value between 0 and 1, the thin of the jumps
in a HMC method. By default, is 0.9.}

\item{tree.depth}{an integer of the maximum depth of the trees  evaluated
during each iteration. By default, is 10.}

\item{prior_mu0}{The prior distribution for the location parameter in an
ARIMA model. By default, sets \code{student(7,0,1)} prior.}

\item{prior_sigma0}{The prior distribution for the scale parameter in an
ARIMA model. By default, declares a \code{student(7,0,1)} prior.}

\item{series.name}{an optional string vector with the series names.}

\item{...}{Further arguments passed to  \code{varstan} function.}
}
\value{
A \code{varstan} object with the fitted naive Random Walk model.
}
\description{
Naive is the model constructor for a random walk  model applied to \code{y}.
This is equivalent to an ARIMA(0,1,0) model. \code{naive()} is simply a wrapper
to  maintain forecast package similitude. \code{seasonal} returns the model
constructor for a seasonal random walk equivalent to an ARIMA(0,0,0)(0,1,0)m
model where m is the seasonal period.
}
\details{
The random walk with drift model is
\deqn{Y_t = mu_0 + Y_{t-1} + epsilon_t}{Y[t]= mu_0 +Y[t-1] + epsilon[t]}
where  \eqn{epsilon_t}{epsilon[t]} is a normal iid error.

The seasonal naive model is
\deqn{Y_t = mu_0 + Y_{t-m} + epsilon_t}{Y[t]= mu_0 +Y[t-m] + epsilon[t]}
where  \eqn{epsilon_t}{epsilon[t]} is a normal iid error.
}
\examples{
\donttest{
 # A seasonal Random-walk model.
 sf1 = stan_naive(birth,seasonal = TRUE,iter = 500,chains = 1)
}

}
\references{
Hyndman, R. & Khandakar, Y. (2008). Automatic time series forecasting: the
forecast package for \code{R}. \emph{Journal of Statistical Software}. 26(3),
1-22.\code{doi:	10.18637/jss.v027.i03}.

Box, G. E. P. and Jenkins, G.M. (1978). Time series analysis: Forecasting and
control. San Francisco: Holden-Day. \emph{Biometrika}, 60(2), 297-303.
\code{doi:10.1093/biomet/65.2.297}.

Kennedy, P. (1992). Forecasting with dynamic regression models: Alan Pankratz, 1991.
\emph{International Journal of Forecasting}. 8(4), 647-648.
\code{url: https://EconPapers.repec.org/RePEc:eee:intfor:v:8:y:1992:i:4:p:647-648}.
}
\seealso{
\code{Sarima}.
}
\author{
Asael Alonzo Matamoros
}
