% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_ou_nonlinear.R
\name{fit_ou_nonlinear_tmg}
\alias{fit_ou_nonlinear_tmg}
\title{Fit Bayesian nonlinear OU model with TMG effect and SV}
\usage{
fit_ou_nonlinear_tmg(
  results_robust,
  Y,
  X,
  TMG,
  COM,
  CAPITAL_TOTAL,
  model = c("base"),
  priors = list(sigma_delta = 0.002),
  com_in_mean = TRUE,
  chains = 6,
  iter = 12000,
  warmup = 6000,
  thin = 2,
  cores = max(1, parallel::detectCores() - 1),
  threads_per_chain = 2,
  hard_sum_zero = TRUE,
  orthogonalize_tmg = TRUE,
  factor_from = c("X", "Y"),
  use_train_loadings = FALSE,
  adapt_delta = 0.97,
  max_treedepth = 12,
  seed = 1234,
  init = NULL,
  moment_match = NULL,
  verbose = FALSE
)
}
\arguments{
\item{results_robust}{List. Previous results object to extend (can be empty list).}

\item{Y}{Numeric matrix (T x S). Dependent variable (prices/values by sector).}

\item{X}{Numeric matrix (T x S). Independent variable (production prices).}

\item{TMG}{Numeric vector (length T). Aggregate TMG series.}

\item{COM}{Numeric matrix (T x S). Composition of capital by sector.}

\item{CAPITAL_TOTAL}{Numeric matrix (T x S). Total capital by sector.}

\item{model}{Character. Model type. Currently only "base" supported.}

\item{priors}{List. Prior specifications. Currently supports sigma_delta.}

\item{com_in_mean}{Logical. Include COM effect in mean equation. Default TRUE.}

\item{chains}{Integer. Number of MCMC chains. Default 6.}

\item{iter}{Integer. Total iterations per chain. Default 12000.}

\item{warmup}{Integer. Warmup iterations. Default 6000.}

\item{thin}{Integer. Thinning interval. Default 2.}

\item{cores}{Integer. Number of cores for parallel chains.}

\item{threads_per_chain}{Integer. Threads per chain for within-chain parallelism.}

\item{hard_sum_zero}{Logical. If TRUE, TMG wedge is fixed at zero. Default TRUE.}

\item{orthogonalize_tmg}{Logical. Orthogonalize TMG w.r.t. common factor. Default TRUE.}

\item{factor_from}{Character. Source for common factor: "X" or "Y". Default "X".}

\item{use_train_loadings}{Logical. Compute factor loadings from training only. Default FALSE.}

\item{adapt_delta}{Numeric. Target acceptance rate (0-1). Default 0.97.}

\item{max_treedepth}{Integer. Maximum tree depth for NUTS. Default 12.}

\item{seed}{Integer. Random seed for reproducibility.}

\item{init}{Numeric or function. Initial values for parameters.}

\item{moment_match}{Logical. Use moment matching for LOO. Default NULL.}

\item{verbose}{Logical. Print progress messages. Default FALSE.}
}
\value{
List containing:
  \describe{
    \item{factor_ou}{Model results including draws and parameter estimates}
    \item{beta_tmg}{Time-varying beta estimates}
    \item{sv}{Stochastic volatility summaries}
    \item{nonlinear}{Nonlinearity diagnostics}
    \item{accounting}{TMG accounting block}
    \item{diagnostics}{MCMC diagnostics, LOO, and OOS metrics}
  }
}
\description{
Fits a Bayesian nonlinear Ornstein-Uhlenbeck model with cubic drift,
stochastic volatility, and Student-t innovations using Stan.
}
\details{
The model uses hierarchical priors for sector-specific parameters.
Training period is set to 70 percent of observations by default.
All data standardization uses training period statistics only.
}
\examples{
\donttest{
# 1. Prepare dummy data
T_obs <- 20
S_sectors <- 2
Y <- matrix(rnorm(T_obs * S_sectors), nrow = T_obs, ncol = S_sectors)
X <- matrix(rnorm(T_obs * S_sectors), nrow = T_obs, ncol = S_sectors)
TMG <- rnorm(T_obs)
COM <- matrix(runif(T_obs * S_sectors), nrow = T_obs, ncol = S_sectors)
K <- matrix(runif(T_obs * S_sectors, 100, 1000), nrow = T_obs, ncol = S_sectors)

# 2. Run model (conditional on Stan backend availability)
# We use very short chains just to demonstrate execution
if (requireNamespace("cmdstanr", quietly = TRUE) || 
    requireNamespace("rstan", quietly = TRUE)) {
  
  # Wrap in try to avoid failure if Stan is not configured locally
  try({
    results <- fit_ou_nonlinear_tmg(
      results_robust = list(),
      Y = Y, X = X, TMG = TMG, COM = COM, CAPITAL_TOTAL = K,
      chains = 1, iter = 100, warmup = 50, # Short run for example
      verbose = FALSE
    )
  }, silent = TRUE)
}
}

}
