% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict_d18oc}
\alias{predict_d18oc}
\title{Predict d18O of foram calcite given seawater temperature and seawater d18O.}
\usage{
predict_d18oc(seatemp, d18osw, foram = NULL, seasonal_seatemp = FALSE,
  drawsfun = get_draws)
}
\arguments{
\item{seatemp}{Numeric or vector of observed sea-surface temperatures (°C).}

\item{d18osw}{Numeric or vector of observed seawater d18O (‰ VSMOW).}

\item{foram}{Optional. String or \code{NULL}. String indicating the foram 
species/subspecies to infer for hierarchical models. String must be one of 
"G. bulloides", "G. ruber", "T. sacculifer", "N. incompta", or 
"N. pachyderma". \code{NULL} indicates that a pooled model is desired.}

\item{seasonal_seatemp}{Optional boolean indicating whether to use the seasonal 
sea-surface temperature calibrations. Default is \code{FALSE}, i.e. using 
annual SST calibrations.}

\item{drawsfun}{Optional function used to get get model parameter draws. Must 
take arguments for "foram" and "seasonal_seatemp" and return a list with 
members "alpha", "beta", "tau". This is for debugging and testing. See 
\code{\link{get_draws}}.}
}
\value{
A \code{prediction} instance for inferred foraminiferal calcite 
d18O (‰ VPDB).
}
\description{
Predict d18O of foram calcite given seawater temperature and seawater d18O.
}
\details{
Four calibration models are available: an "annual pooled" model, a 
"seasonal pooled" model, an "annual hierarchical" model, and a 
"seasonal hierarchical" model. This function uses magic to determine which 
"pooled annual" model is used. Which is the simplest case with potential use 
for Deep Time reconstructions of nonexant foram species. Giving a valid string 
for \code{foram} will use a hierarchical model, which has foram-specific 
variability in calibration model parameters. Passing \code{TRUE} for 
\code{seasonal_seatemp} will use a model trained on season sea-surface 
temperatures. See reference paper for further details.
}
\examples{
# Infer d18Oc for a G. bulloides core top sample using annual hierarchical model.
# The true, d18Oc for this sample is -2.16 (‰ VPDB).
delo_ann <- predict_d18oc(seatemp=28.6, d18osw=0.48, foram="G. bulloides")
head(quantile(delo_ann, probs=c(0.159, 0.5, 0.841)))  # ± 1 standard deviation

# Now using seasonal hierarchical model:
delo_sea <- predict_d18oc(seatemp=28.6, d18osw=0.48, foram="G. bulloides",
                          seasonal_seatemp = TRUE)
head(quantile(delo_sea, probs=c(0.159, 0.5, 0.841)))  # ± 1 standard deviation

}
\seealso{
\code{\link{predict_seatemp}}, \code{\link{predictplot}}
}
