% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.r
\name{bb.plot}
\alias{bb.plot}
\title{Plots the log of prices and highlight bear states}
\usage{
bb.plot(price, bull, dates, price.name=NULL, log.scale=TRUE)
}
\arguments{
\item{price}{a numeric vector of price values}

\item{bull}{a logical vector that contains the states of the market. This vector
is returned by function \code{\link{run_dating_alg}} or \code{\link{run_filtering_alg}}.}

\item{dates}{a vector of dates in Date format}

\item{price.name}{the name of the time-series of prices that will appear on the y-axis of the plot}

\item{log.scale}{a logical variable that specifies whether to use log scale along the y-axis}
}
\value{
None
}
\description{
This function plots the log of prices and highlights bear states
}
\examples{
{
library(zoo)
library(xtable)
library(ggplot2)
price <- as.vector(coredata(sp500m)) # retrieve monthly prices
dates <- index(sp500m) # retrieve dates from zoo-object
setpar_dating_alg(4, 6, 5, 15, 20) # parameters for monthly data
bull <- run_dating_alg(price) # detect bull-bear states
bb.plot(price, bull, dates, "S&P 500") # plot the result
}
}
