% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{setpar_dating_alg}
\alias{setpar_dating_alg}
\title{Sets the paramters of the dating algorithm}
\usage{
setpar_dating_alg(t_window, t_censor, t_phase, t_cycle, max_chng)
}
\arguments{
\item{t_window}{the half-size of the rolling window to find minima and maxima}

\item{t_censor}{the size of the left and right margin (for the cencoring operation)}

\item{t_phase}{the minimum phase (bull or bear) length}

\item{t_cycle}{the minimum full cycle length}

\item{max_chng}{the change (in percentages) in the \code{"index"} that invalidates the minimum phase length rule}
}
\value{
None
}
\description{
This function sets the paramters of the dating algorithm of Bry and Boschan (1971)
}
\note{
All parameters but \code{"max_chng"} are given in a number of observations.
For example, if data are at the monthly frequency, \code{"t_cycle=16"} defines that the minimum cycle length should be 16 months.
}
\references{
Bry, G. and Boschan, C. (1971). Cyclical Analysis of Time Series: Selected Procedures and
Computer Programs. NBER.

Pagan, A. R. and Sossounov, K. A. (2003). A Simple Framework for Analysing Bull and Bear
Markets. Journal of Applied Econometrics, 18 (1), 23-46.

Gonzalez, L., Powell, J. G., Shi, J., and Wilson, A. (2005). Two Centuries of Bull and Bear
Market Cycles. International Review of Economics and Finance, 14 (4), 469-486.
}
