% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbmix.R
\name{poolreads}
\alias{poolreads}
\title{Pool randomly selected reads from different files}
\usage{
poolreads(files, N = 1000, d = 10, out)
}
\arguments{
\item{files}{names for files to extract reads}

\item{N}{number of reads to extract}

\item{d}{depth for reads}

\item{out}{file name to save reads}
}
\value{
save files
}
\description{
Pool randomly selected reads from different files
}
\examples{
counts_f <- system.file("extdata/input", "NA12878.chr22.Q20.allelicCounts.txt",
package = "bbmix",
mustWork = TRUE)

## In this example we only use one file and we take a pool of 10 reads

out <- tempfile()

poolreads(files=counts_f,
N=10,
d=10,
out = out)

unlink(out)

}
