% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/31_zShortingStockIndexFutureAtFairValue.R
\name{zShortingStockIndexFutureAtFairValue}
\alias{zShortingStockIndexFutureAtFairValue}
\title{Calculates  Profit and Loss at closeout of shorted a Stock Index Future (like Micro E-mini) and draws its graph in the Plots tab.}
\usage{
zShortingStockIndexFutureAtFairValue(
  SIT,
  SI0,
  R,
  d,
  n,
  hl = 0.9995,
  hu = 1.006,
  xlab = "Stock Index at closeout",
  ylab = " Profit / Loss [PnL] at closeout ($)",
  main = "Shorting a Stock Index like Micro E-mini S & P 500 [ PnL]"
)
}
\arguments{
\item{SIT}{Stock Index at time T.}

\item{SI0}{Stock Index Initial Value.}

\item{R}{annualized financing rate}

\item{d}{dividend yield of the index.}

\item{n}{represents days in Future like 90day Stock Index Future.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{main}{Title of the Graph.}
}
\value{
Returns a graph of the strategy.
}
\description{
On initiation, this is a net credit Strategy and results in net cash inflow in the form of receiving the amount of shorted Stock Index Future. On the day of the closeout the trader or investor has to buy the underlying at the price at the time of closeout. If the bearish outlook of the trader is as expected and the Stock Index Future (like Micro E-mini) falls then the trader makes the profit as shown in the graph (TD Ameritrade, 2019).
}
\details{
According to the information provided by TD Ameritrade (2019) and  Hull (2022), this method is developed, and the given examples are created, to compute Profit and Loss at closeout of shorted a Stock Index Future (like Micro E-mini) and draw its graph in the Plots tab.
}
\examples{
zShortingStockIndexFutureAtFairValue(3700,3709,0.0275,0.02,90)
zShortingStockIndexFutureAtFairValue(2900,2910,0.025,0.03,90,hl=0.9995,hu=1.005)
}
\references{
TD Ameritrade. (2019, July 26). Micro E-Mini Futures Contracts. YouTube.https://youtu.be/SShGjJepCdA\cr
Hull, J. C. (2022). Options, Futures, and Other Derivatives (11th ed.). Pearson Education (US). https://bookshelf.vitalsource.com/books/9780136940043.
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
