% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tte-sim.R
\name{sim_weib_ph}
\alias{sim_weib_ph}
\title{Simulate Event Times for Each Participant from a Weibull Proportional Hazards
Regression Model}
\usage{
sim_weib_ph(weibull_ph_mod, samp_df, cond_drift = 0, cond_trt_effect = 0)
}
\arguments{
\item{weibull_ph_mod}{\code{survreg} object corresponding to a Weibull
proportional hazards model fit using the external data}

\item{samp_df}{Data frame of covariates corresponding to the sample arm
(control or treated) for which event times should be simulated. The column
names should correspond to the covariate names in the \code{survreg} object.}

\item{cond_drift}{Optional value of the conditional drift by which the
intercept in the Weibull proportional hazards regression model should be
increased/decreased to incorporate the impact of unmeasurable sources of
drift. Default is 0.}

\item{cond_trt_effect}{Optional value of the conditional treatment effect by
which the intercept in the Weibull proportional hazards regression model
should be increased/decreased if simulating event data for a treated arm.
Default is 0.}
}
\value{
Vector of simulated event times from a Weibull proportional hazards
regression model
}
\description{
Simulate Event Times for Each Participant from a Weibull Proportional Hazards
Regression Model
}
\details{
Simulate the event times for each participant using a Weibull
proportional hazards (PH) regression model. The "true" parameter values
for the Weibull shape \eqn{\alpha} and the regression coefficients
\eqn{\boldsymbol{\beta}} are assumed to be equal to the parameter estimates
from a \code{survreg} object (\code{weibull_ph_mod}) fit using external data (note
that the Weibull shape parameter \eqn{\alpha} is defined as the inverse of
the scale parameter reported by \code{survreg}).

For participant \eqn{i}, let \eqn{y_i} denote the time-to-event random
variable and \eqn{\boldsymbol{x}_i = \{x_{i,1}, \ldots, x_{i,p}\}} the
vector of \eqn{p} covariates (row \eqn{i} of \code{samp_df}) that correspond
to the \eqn{(p+1)}-dimensional vector of regression coefficients
\eqn{\boldsymbol{\beta}}. The density function of the Weibull PH regression
model is

\deqn{f(y_i \mid \boldsymbol{x}_i, \alpha, \boldsymbol{\beta}, \delta, \gamma)
  = \left( \frac{\alpha}{\sigma_i} \right) \left( \frac{y_i}{\sigma_i}
  \right)^{\alpha - 1} \exp \left( -\left( \frac{y_i}{\sigma_i} \right)^\alpha \right),}

where \eqn{-\log(\sigma_i) = \beta_0 + \beta_1 x_{i,1} + \ldots +
  \beta_p x_{i,p} + \delta + \gamma}. Here, \eqn{\delta} and \eqn{\gamma}
denote the conditional drift (\code{cond_drift}) and conditional treatment
effect (\code{cond_trt_effect}), respectively, that can be calculated using
\code{\link[=calc_cond_weibull]{calc_cond_weibull()}} for desired values of the marginal drift and marginal
treatment effect.
}
\examples{
library(dplyr)
library(survival)
# Model "true" regression coefficients and shape parameter using the external data
weibull_ph_mod <- survreg(Surv(y, event) ~ cov1 + cov2 + cov3 + cov4, data = ex_tte_df,
                          dist = "weibull")

# Sample covariates for internal control arm via bootstrap from external data
samp_int_ctrl <- bootstrap_cov(ex_tte_df, n = 100) |>
  select(c(cov1, cov2, cov3, cov4))     # keep only covariate columns
tte_dat <- sim_weib_ph(weibull_ph_mod, samp_df = samp_int_ctrl)
}
