% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_input_data.R
\name{create_beast2_input_data}
\alias{create_beast2_input_data}
\title{Creates the \code{data} section of a BEAST2 XML parameter file}
\usage{
create_beast2_input_data(
  input_filename,
  beauti_options = create_beauti_options()
)
}
\arguments{
\item{input_filename}{A FASTA filename.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{beauti_options}{one BEAUti options object,
as returned by \code{\link{create_beauti_options}}}
}
\value{
lines of XML text
}
\description{
Creates the \code{data} section of a BEAST2 XML parameter file
}
\examples{
check_empty_beautier_folder()

create_beast2_input_data(
  input_filename = get_fasta_filename(),
  beauti_options = create_beauti_options_v2_4()
)

check_empty_beautier_folder()
}
\author{
Richèl J.C. Bilderbeek
}
