% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{hill}
\alias{hill}
\alias{hill0}
\alias{hill1}
\alias{hill2}
\title{Hill's Diversity Numbers}
\usage{
hill(taxon, count, a = 0)

hill0(taxon, count)

hill1(taxon, count)

hill2(taxon, count)
}
\arguments{
\item{taxon}{character vector containing taxa}

\item{count}{numeric vector containing counts}

\item{a}{exponent in Hill's diversity number (R, with special cases for
\code{a} in \{0, 1, 2\} (see details))}
}
\value{
numeric vector of Hill's numbers
}
\description{
According to Hill (1973): \emph{"a diversity number is figuratively a
measure of how many species are present if we examine the sample down to a
certain depth among its rarities. If we examine superficially (e.g.,
by using \eqn{N_2}{N[2]}) we shall see only the more abundant species. If we
look deeply (e.g., by using \eqn{N_0}{N[0]}) we shall see all the
species present."}
}
\details{
Hill's diversity numbers are given by:
\deqn{N_a=\sum{i=1}^S (p_i^a)^{1/(1-a)}}

Special cases are:
\describe{
     \item{\eqn{N_{-\infty}}{N[-Inf]}}{reciprocal of the proportional
         abundance of the rarest species;}
     \item{\eqn{N_0}{N[0]}}{total number of species present;}
     \item{\eqn{N_1}{N[1]}}{exp(H), where H: Shannon's index (see also
         \code{\link{shannon}});}
     \item{\eqn{N_2}{N[2]}}{reciprocal of Simpson's index (see also
         \code{\link{simpson}});}
     \item{\eqn{N_{\infty}}{N[Inf]}}{reciprocal of the proportional
         abundance of the commonest species.}
}
}
\section{Functions}{
\itemize{
\item \code{hill0()}: \eqn{N_0}{N[0]}

\item \code{hill1()}: \eqn{N_1}{N[1]}

\item \code{hill2()}: \eqn{N_2}{N[2]}

}}
\examples{
     hill(
         taxon = c("Euspira pulchella", "Nephtys cirrosa"),
         count = c(6, 12),
         a = 0
     )
     hill0(
         taxon = c("Euspira pulchella", "Nephtys cirrosa"),
         count = c(6, 12)
     )

}
\references{
Hill, M.O., 1973. Diversity and Evenness:
     A Unifying Notation and Its Consequences. Ecology 54:427-432
}
\seealso{
\code{\link{species_richness}}, \code{\link{shannon}},
     \code{\link{simpson}}
}
