% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_most_representative_docs.R
\name{get_most_representative_docs}
\alias{get_most_representative_docs}
\title{Get Most Representative Documents for a Specific Topic}
\usage{
get_most_representative_docs(df, topic_nr, n_docs = 5)
}
\arguments{
\item{df}{A data frame containing at least the columns 'Topic', 'Document', and 'probs'.}

\item{topic_nr}{An integer specifying the topic number to filter the documents.}

\item{n_docs}{An integer specifying the number of top representative documents to return. Defaults to 5.}
}
\value{
A vector of the most representative documents corresponding to the specified topic.
If the number of documents available is less than \code{n_docs}, all available documents are returned.
}
\description{
This function filters a given data frame to select the most representative documents
for a specified topic based on their probability scores. The documents are sorted by
relevance in descending order, and the top n documents are returned.
}
\examples{
\donttest{
if (exists("df_docs")) {
  # df_docs must contain columns Topic, Document, and probs
  get_most_representative_docs(df_docs, topic_nr = 3, n_docs = 5)
} else {
  message("No df_docs found. Create it before running this example.")
}
}
}

