% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/bids.R
\name{load_all_events}
\alias{load_all_events}
\alias{load_all_events.bids_project}
\title{Load All Event Files}
\usage{
load_all_events(x, ...)

\method{load_all_events}{bids_project}(
  x,
  subid = ".*",
  task = ".*",
  run = ".*",
  session = ".*",
  full_path = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{bids_project} object.}

\item{...}{Additional arguments passed on to \code{search_files}.}

\item{subid}{A regex for matching participant IDs. Default is \code{".*"}.}

\item{task}{A regex for matching tasks. Default is \code{".*"}.}

\item{run}{A regex for matching runs. Default is \code{".*"}.}

\item{session}{A regex for matching sessions. Default is \code{".*"}.}

\item{full_path}{If TRUE, return full file paths before reading. Default is TRUE.}
}
\value{
A tibble containing the combined event data.

A tibble combining all matched event files, with columns \code{.subid}, \code{.task}, \code{.run}, \code{.session}
and all event columns. If no events are found, returns an empty tibble.
}
\description{
Searches for and reads event files (\code{events.tsv}) from a BIDS
project, combining them into a single (potentially nested) tibble.

This function searches for all \code{events.tsv} files that match the provided
filters (subid, task, run, session) and loads them into a single tibble.
If \code{full_path=TRUE}, full file paths are returned; otherwise relative paths.
}
\examples{
\donttest{
# Example with a bids_project (assuming events exist)
tryCatch({
  ds001_path <- get_example_bids_dataset("ds001")
  proj <- bids_project(ds001_path)
  all_events <- load_all_events(proj)
  print(all_events)
  
  # Load specific subject/task
  if (length(participants(proj)) > 0) {
    sub01_events <- load_all_events(proj, subid=participants(proj)[1], task="balloonanalogrisktask")
    print(sub01_events)
  }
  
  # Clean up
  unlink(ds001_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
}
