% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa_boot2_ls.R
\name{bfa_boot2_ls}
\alias{bfa_boot2_ls}
\title{Double Bootstrap of Least Squares Estimators of BAR(p) Models}
\usage{
bfa_boot2_ls(z, p, burn = 5, B1, B2)
}
\arguments{
\item{z}{a numeric vector containing the tree data}

\item{p}{an integer determining the order of bifurcating autoregressive model
to be fit to the data}

\item{burn}{number of tree generations to discard before starting the
bootstrap sample (replicate)}

\item{B1}{number of bootstrap samples (replicates) used in first round of
bootstrapping}

\item{B2}{number of bootstrap samples (replicates) used in second round of
bootstrapping}
}
\value{
\item{boot_est}{a matrix containing the first-stage bootstrapped
least squares estimates of the autoregressive coefficients} \item{boot2}{a
matrix containing the second-stage bootstrapped least squares estimates of
the autoregressive coefficients}
}
\description{
This function performs double bootstrapping of the least squares estimators
of the autoregressive coefficients in a bifurcating autoregressive (BAR)
model of any order \code{p} as described in Elbayoumi and Mostafa (2020).
}
\examples{
z <- bfa_tree_gen(31, 1, 1, 1, 0.5, 0.5, 0, 10, c(0.7))
bfa_boot2_ls(z, p=1, B1=99, B2=9)
}
\references{
Elbayoumi, T. M. & Mostafa, S. A. (2020). On the estimation bias
in bifurcating autoregressive models. \emph{Stat}, 1-16.
}
