% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa_boot_ls_bc.R
\name{bfa_boot_ls_bc}
\alias{bfa_boot_ls_bc}
\title{Bootstrap of Bias-Correction Least Squares Estimators of BAR(p) Models}
\usage{
bfa_boot_ls_bc(
  z,
  p,
  method = "boot1",
  burn = 5,
  B,
  boot_est = TRUE,
  boot_data = FALSE
)
}
\arguments{
\item{z}{a numeric vector containing the tree data}

\item{p}{an integer determining the order of bifurcating autoregressive model
to be fit to the data}

\item{method}{method of bias correction. Currently, "boot1", "boot2",
"boot2fast" and "LBC" are supported and they implement single bootstrap,
double bootstrap, fast-double bootstrap, and linear-bias-function
bias-correction, respectively.}

\item{burn}{number of tree generations to discard before starting the
bootstrap sample (replicate)}

\item{B}{number of bootstrap samples (replicates)}

\item{boot_est}{a logical that determines whether the bootstrapped least
squares estimates of the autoregressive coefficients should be returned.
Defaults to TRUE.}

\item{boot_data}{a logical that determines whether the bootstrap samples
should be returned. Defaults to FALSE.}
}
\value{
\item{boot_bcest}{a matrix containing the bootstrapped bias-correction
least squares estimates of the autoregressive coefficients} \item{boot_data}{a matrix
containing the bootstrap samples used}
}
\description{
This function performs linear-bias-function bias-correction (LBC), single
bootstrap, double bootstrap, fast-double bootstrap of the bias-correction
least squares estimators of the autoregressive coefficients in a bifurcating
autoregressive (BAR) model of any order \code{p} as described in Elbayoumi &
Mostafa (2020).
}
\examples{
z <- bfa_tree_gen(31, 1, 1, 1, 0.5, 0.5, 0, 10, c(0.7))
bfa_boot_ls_bc(z, p=1, method="LBC", B=500)
hist(bfa_boot_ls_bc(z, p=1, method="LBC", B=500)$boot_bcest)
}
\references{
Elbayoumi, T. M. & Mostafa, S. A. (2020). On the estimation bias
in bifurcating autoregressive models. \emph{Stat}, 1-16.
}
