% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa_tree_gen.R
\name{bfa_tree_gen}
\alias{bfa_tree_gen}
\title{Bifurcating Autoregressive Tree generator}
\usage{
bfa_tree_gen(n, p, s1, s2, r1, r2, g, intercept, ar_coef, dist = "cnorm", a)
}
\arguments{
\item{n}{tree size (integer)}

\item{p}{an integer determining the order of bifurcating autoregressive model}

\item{s1}{standard deviation of the errors distribution}

\item{s2}{standard deviation of the second component of the mixture normal
distribution generating contaminated errors. s2 should be greater than s1.
s2 is only effective when g>0.}

\item{r1}{correlation between pairs of errors}

\item{r2}{is used in combination with \code{r1} to compute the correlation
between pairs of errors in the second component of the mixture normal
distribution generating the contaminated errors. r2 is only effective when
g>0.}

\item{g}{proportion of contamination when contaminated normal distribution is
selected, or a positive value representing the degrees
of freedom when skew t-student distribution is selected. Defaults to zero
producing non-contaminated multivariate normal errors.}

\item{intercept}{the intercept in the BAR model generating the tree}

\item{ar_coef}{a vector of length p giving the autoregressive coefficients in
the BAR model generating the tree}

\item{dist}{determine the distribution of the error. Three distributions are
available; Contaminated normal distribution "cnorm", Skew normal distribution
"snorm", and Skew t-student distribution "st".}

\item{a}{an integer which regulates the the slant of the density when skew
normal distribution or skew t-student distribution is selected. Defaults to zero
producing non-skewed multivariate normal errors, and non-skewed multivariate
t-student errors for the tree generation.}
}
\value{
A numeric vector representing a bifurcating autoregressive (BAR) tree
with \code{n} observations.
}
\description{
This function generate bifurcating autoregressive (BFA) trees of any size
based on a BFA model of any order.
}
\examples{
# Non-contaminated normal BAR(1) tree:
bfa_tree_gen(127, 1, 1, 1, 0.5, 0.5, 0, 10, c(0.7))
# Non-contaminated normal BAR(2) tree:
bfa_tree_gen(127, 2, 1, 1, 0.5, 0.5, 0, 10, c(0.5, 0.3))
# Contaminated normal BAR(1) tree:
bfa_tree_gen(127, 1, 1, 2, 0.5, 0.5, 0.2, 10, c(0.7))
# BAR(1) tree with error generated from skewed normal distribution with skewness equals to -3:
bfa_tree_gen(127, 1, 1, 2, 0.5, 0.5, 0, 10, c(0.7),dist="snorm",-3)
# BAR(2) tree with error generated from skewed normal distribution with skewness equals to 3:
bfa_tree_gen(127, 2, 1, 2, 0.5, 0.5, 0, 10, c(0.7,0.5),dist="snorm",3)
# BAR(1) tree with error generated from skewed-t distribution with skewness equals
# to -3 and df equals to 10:
bfa_tree_gen(127, 1, 1, 2, 0.5, 0.5, 10, 10, c(0.7),dist="st",-3)
# BAR(2) tree with error generated from skewed-t distribution with skewness equals
# to 3 and df equals to 1:
bfa_tree_gen(127, 2, 1, 2, 0.5, 0.5, 10, 10, c(0.7,0.5),dist="st",3)
}
