% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kf_pls_state.R
\name{kf_pls_state_update}
\alias{kf_pls_state_update}
\title{Update a KF-PLS streaming state with a mini-batch}
\usage{
kf_pls_state_update(state, X_chunk, Y_chunk)
}
\arguments{
\item{state}{External pointer produced by \code{\link[=kf_pls_state_new]{kf_pls_state_new()}}.}

\item{X_chunk}{Numeric matrix with the same number of columns \code{p} used to
create the state.}

\item{Y_chunk}{Numeric matrix with \code{m} columns (or a numeric vector if
\code{m == 1}). Must have the same number of rows as \code{X_chunk}.}
}
\value{
Invisibly returns \code{state}, updated in place.
}
\description{
Feed one chunk (\code{X_chunk}, \code{Y_chunk}) to an existing KF-PLS state created by
\code{\link[=kf_pls_state_new]{kf_pls_state_new()}}. The function updates exponentially weighted means and
cross-products (or exact sufficient statistics when in exact mode).
}
\details{
Call this repeatedly for each incoming batch. When you want model
coefficients (weights/loadings/intercepts), call
\code{\link[=kf_pls_state_fit]{kf_pls_state_fit()}}, which solves SIMPLS on the accumulated
cross-moments without re-materializing all past data.
}
\seealso{
\code{\link[=kf_pls_state_new]{kf_pls_state_new()}}, \code{\link[=kf_pls_state_fit]{kf_pls_state_fit()}}
}
