% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blas_extras.R
\name{dhprod}
\alias{dhprod}
\title{Element-wise (Hadamard) product}
\usage{
dhprod(N = NULL, X, INCX = 1L, Y, INCY = 1L, Z, INCZ = 1L)
}
\arguments{
\item{N}{Optional integer giving the number of elements. Defaults to `length(X)`.}

\item{X}{Double-precision vector, matrix or [`bigmemory::big.matrix`] input.}

\item{INCX}{Integer stride for traversing `X`.}

\item{Y}{Double-precision object updated in place.}

\item{INCY}{Integer stride for traversing `Y`.}

\item{Z}{Optional output container receiving the product.}

\item{INCZ}{Integer stride for `Z`.}
}
\value{
The updated object `Z`.
}
\description{
Computes \eqn{Z := X \circ Y}. When `Z` is missing it is allocated automatically.
}
\examples{
dhprod(X = 1:4, Y = rep(2, 4))

}
